/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.dashj.bls.AggregationInfo;
import org.dashj.bls.BLSObject;
import org.dashj.bls.InsecureSignature;
import org.dashj.bls.JNI;
import org.dashj.bls.SWIGTYPE_p_g2_t;
import org.dashj.bls.SignatureVector;
import org.dashj.bls.Utils;

public class Signature
extends BLSObject {
    public static final long SIGNATURE_SIZE = JNI.Signature_SIGNATURE_SIZE_get();

    protected Signature(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    protected static long getCPtr(Signature obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    @Override
    public synchronized void delete() {
        JNI.delete_Signature(this.cPointer);
    }

    public static Signature FromBytes(byte[] data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument(((long)data.length == SIGNATURE_SIZE ? 1 : 0) != 0);
        return new Signature(JNI.Signature_FromBytes__SWIG_0(data), true);
    }

    public static Signature FromBytes(byte[] data, AggregationInfo info) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument(((long)data.length == SIGNATURE_SIZE ? 1 : 0) != 0);
        return new Signature(JNI.Signature_FromBytes__SWIG_1(data, AggregationInfo.getCPtr(info)), true);
    }

    public static Signature FromG2(SWIGTYPE_p_g2_t element) {
        return new Signature(JNI.Signature_FromG2__SWIG_0(SWIGTYPE_p_g2_t.getCPtr(element)), true);
    }

    public static Signature FromG2(SWIGTYPE_p_g2_t element, AggregationInfo info) {
        return new Signature(JNI.Signature_FromG2__SWIG_1(SWIGTYPE_p_g2_t.getCPtr(element), AggregationInfo.getCPtr(info)), true);
    }

    public static Signature FromInsecureSig(InsecureSignature sig) {
        return new Signature(JNI.Signature_FromInsecureSig__SWIG_0(InsecureSignature.getCPtr(sig), sig), true);
    }

    public static Signature FromInsecureSig(InsecureSignature sig, AggregationInfo info) {
        return new Signature(JNI.Signature_FromInsecureSig__SWIG_1(InsecureSignature.getCPtr(sig), sig, AggregationInfo.getCPtr(info)), true);
    }

    public Signature(Signature signature) {
        this(JNI.new_Signature(Signature.getCPtr(signature), signature), true);
    }

    public boolean Verify() {
        return JNI.Signature_Verify(this.cPointer, this);
    }

    public static Signature AggregateSigs(SignatureVector sigs) {
        Preconditions.checkNotNull((Object)sigs);
        return new Signature(JNI.Signature_AggregateSigs(SignatureVector.getCPtr(sigs)), true);
    }

    public Signature DivideBy(SignatureVector divisorSigs) {
        Preconditions.checkNotNull((Object)divisorSigs);
        return new Signature(JNI.Signature_DivideBy(this.cPointer, this, SignatureVector.getCPtr(divisorSigs)), true);
    }

    public AggregationInfo GetAggregationInfo() {
        long cPtr = JNI.Signature_GetAggregationInfo(this.cPointer, this);
        return cPtr == 0L ? null : new AggregationInfo(cPtr, false);
    }

    public void SetAggregationInfo(AggregationInfo newAggregationInfo) {
        JNI.Signature_SetAggregationInfo(this.cPointer, this, AggregationInfo.getCPtr(newAggregationInfo));
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= SIGNATURE_SIZE ? 1 : 0) != 0);
        JNI.Signature_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)SIGNATURE_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "Signature(" + Utils.HEX.encode(this.Serialize()) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Signature)) {
            return false;
        }
        Signature signature = (Signature)obj;
        byte[] theseBytes = new byte[(int)SIGNATURE_SIZE];
        this.Serialize(theseBytes);
        byte[] signatureBytes = new byte[(int)SIGNATURE_SIZE];
        signature.Serialize(signatureBytes);
        return Arrays.equals(theseBytes, signatureBytes);
    }
}

