/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.JNI;
import org.dashj.bls.Signature;

public class SignatureVector
extends AbstractList<Signature> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected SignatureVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SignatureVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_SignatureVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public SignatureVector(Collection<Signature> e) {
        this.reserve(e.size());
        for (Signature value : e) {
            this.push_back(value);
        }
    }

    public SignatureVector() {
        this(JNI.new_SignatureVector__SWIG_0(), true);
    }

    public SignatureVector(SignatureVector o) {
        this(JNI.new_SignatureVector__SWIG_2(SignatureVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.SignatureVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JNI.SignatureVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.SignatureVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JNI.SignatureVector_clear(this.swigCPtr, this);
    }

    public void push_back(Signature x) {
        Preconditions.checkNotNull((Object)x);
        JNI.SignatureVector_push_back(this.swigCPtr, this, Signature.getCPtr(x), x);
    }

    @Override
    public Signature get(int i) {
        return new Signature(JNI.SignatureVector_get(this.swigCPtr, this, i), false);
    }

    @Override
    public Signature set(int i, Signature VECTOR_VALUE_IN) {
        Preconditions.checkNotNull((Object)VECTOR_VALUE_IN);
        return new Signature(JNI.SignatureVector_set(this.swigCPtr, this, i, Signature.getCPtr(VECTOR_VALUE_IN), VECTOR_VALUE_IN), true);
    }

    @Override
    public int size() {
        return JNI.SignatureVector_size(this.swigCPtr, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.SignatureVector_removeRange(this.swigCPtr, this, from, to);
    }
}

