/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;

public class LargestBlobCropTransform
extends BaseImageTransform<Mat> {
    protected Random rng = Nd4j.getRandom();
    protected int mode;
    protected int method;
    protected int blurWidth;
    protected int blurHeight;
    protected int upperThresh;
    protected int lowerThresh;
    protected boolean isCanny;
    private int x;
    private int y;

    public LargestBlobCropTransform() {
        this(null);
    }

    public LargestBlobCropTransform(java.util.Random random) {
        this(random, 2, 2, 3, 3, 100, 200, true);
    }

    public LargestBlobCropTransform(java.util.Random random, int mode, int method, int blurWidth, int blurHeight, int lowerThresh, int upperThresh, boolean isCanny) {
        super(random);
        this.mode = mode;
        this.method = method;
        this.blurWidth = blurWidth;
        this.blurHeight = blurHeight;
        this.lowerThresh = lowerThresh;
        this.upperThresh = upperThresh;
        this.isCanny = isCanny;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, java.util.Random random) {
        if (image == null) {
            return null;
        }
        Mat original = (Mat)this.converter.convert(image.getFrame());
        Mat grayed = new Mat();
        opencv_imgproc.cvtColor((Mat)original, (Mat)grayed, (int)6);
        if (this.blurWidth > 0 && this.blurHeight > 0) {
            opencv_imgproc.blur((Mat)grayed, (Mat)grayed, (Size)new Size(this.blurWidth, this.blurHeight));
        }
        Mat edgeOut = new Mat();
        if (this.isCanny) {
            opencv_imgproc.Canny((Mat)grayed, (Mat)edgeOut, (double)this.lowerThresh, (double)this.upperThresh);
        } else {
            opencv_imgproc.threshold((Mat)grayed, (Mat)edgeOut, (double)this.lowerThresh, (double)this.upperThresh, (int)0);
        }
        double largestArea = 0.0;
        Rect boundingRect = new Rect();
        MatVector contours = new MatVector();
        Mat hierarchy = new Mat();
        opencv_imgproc.findContours((Mat)edgeOut, (MatVector)contours, (Mat)hierarchy, (int)this.mode, (int)this.method);
        int i = 0;
        while ((long)i < contours.size()) {
            double area = opencv_imgproc.contourArea((Mat)contours.get((long)i), (boolean)false);
            if (area > largestArea) {
                boundingRect = opencv_imgproc.boundingRect((Mat)contours.get((long)i));
            }
            ++i;
        }
        this.x = boundingRect.x();
        this.y = boundingRect.y();
        Mat result = original.apply(boundingRect);
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }

    public Random getRng() {
        return this.rng;
    }

    public int getMode() {
        return this.mode;
    }

    public int getMethod() {
        return this.method;
    }

    public int getBlurWidth() {
        return this.blurWidth;
    }

    public int getBlurHeight() {
        return this.blurHeight;
    }

    public int getUpperThresh() {
        return this.upperThresh;
    }

    public int getLowerThresh() {
        return this.lowerThresh;
    }

    public boolean isCanny() {
        return this.isCanny;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setRng(Random rng) {
        this.rng = rng;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void setBlurWidth(int blurWidth) {
        this.blurWidth = blurWidth;
    }

    public void setBlurHeight(int blurHeight) {
        this.blurHeight = blurHeight;
    }

    public void setUpperThresh(int upperThresh) {
        this.upperThresh = upperThresh;
    }

    public void setLowerThresh(int lowerThresh) {
        this.lowerThresh = lowerThresh;
    }

    public void setCanny(boolean isCanny) {
        this.isCanny = isCanny;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LargestBlobCropTransform)) {
            return false;
        }
        LargestBlobCropTransform other = (LargestBlobCropTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getMethod() != other.getMethod()) {
            return false;
        }
        if (this.getBlurWidth() != other.getBlurWidth()) {
            return false;
        }
        if (this.getBlurHeight() != other.getBlurHeight()) {
            return false;
        }
        if (this.getUpperThresh() != other.getUpperThresh()) {
            return false;
        }
        if (this.getLowerThresh() != other.getLowerThresh()) {
            return false;
        }
        if (this.isCanny() != other.isCanny()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        Random this$rng = this.getRng();
        Random other$rng = other.getRng();
        return !(this$rng == null ? other$rng != null : !this$rng.equals(other$rng));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LargestBlobCropTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMode();
        result = result * 59 + this.getMethod();
        result = result * 59 + this.getBlurWidth();
        result = result * 59 + this.getBlurHeight();
        result = result * 59 + this.getUpperThresh();
        result = result * 59 + this.getLowerThresh();
        result = result * 59 + (this.isCanny() ? 79 : 97);
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        Random $rng = this.getRng();
        result = result * 59 + ($rng == null ? 43 : $rng.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LargestBlobCropTransform(rng=" + this.getRng() + ", mode=" + this.getMode() + ", method=" + this.getMethod() + ", blurWidth=" + this.getBlurWidth() + ", blurHeight=" + this.getBlurHeight() + ", upperThresh=" + this.getUpperThresh() + ", lowerThresh=" + this.getLowerThresh() + ", isCanny=" + this.isCanny() + ", x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

