/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.common;

import java.util.List;
import java.util.Map;
import org.dromara.dynamictp.adapter.common.DtpAdapter;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.event.AlarmCheckEvent;
import org.dromara.dynamictp.common.event.CollectEvent;
import org.dromara.dynamictp.common.event.RefreshEvent;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.core.handler.CollectorHandler;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class DtpAdapterListener
implements GenericApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(DtpAdapterListener.class);

    public boolean supportsEventType(ResolvableType resolvableType) {
        Class type = resolvableType.getRawClass();
        if (type != null) {
            return RefreshEvent.class.isAssignableFrom(type) || CollectEvent.class.isAssignableFrom(type) || AlarmCheckEvent.class.isAssignableFrom(type);
        }
        return false;
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        try {
            if (event instanceof RefreshEvent) {
                this.doRefresh(((RefreshEvent)event).getDtpProperties());
            } else if (event instanceof CollectEvent) {
                this.doCollect(((CollectEvent)event).getDtpProperties());
            } else if (event instanceof AlarmCheckEvent) {
                this.doAlarmCheck(((AlarmCheckEvent)event).getDtpProperties());
            }
        }
        catch (Exception e) {
            log.error("DynamicTp adapter, event handle failed.", (Throwable)e);
        }
    }

    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return true;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void doCollect(DtpProperties dtpProperties) {
        Map handlerMap = ApplicationContextHolder.getBeansOfType(DtpAdapter.class);
        if (CollectionUtils.isEmpty((Map)handlerMap)) {
            return;
        }
        handlerMap.forEach((k, v) -> v.getMultiPoolStats().forEach(ps -> CollectorHandler.getInstance().collect(ps, dtpProperties.getCollectorTypes())));
    }

    protected void doRefresh(DtpProperties dtpProperties) {
        Map handlerMap = ApplicationContextHolder.getBeansOfType(DtpAdapter.class);
        if (CollectionUtils.isEmpty((Map)handlerMap)) {
            return;
        }
        handlerMap.forEach((k, v) -> v.refresh(dtpProperties));
    }

    protected void doAlarmCheck(DtpProperties dtpProperties) {
        Map handlerMap = ApplicationContextHolder.getBeansOfType(DtpAdapter.class);
        if (CollectionUtils.isEmpty((Map)handlerMap)) {
            return;
        }
        handlerMap.forEach((k, v) -> {
            Map<String, ExecutorWrapper> executorWrapper = v.getExecutorWrappers();
            executorWrapper.forEach((kk, vv) -> AlarmManager.tryAlarmAsync((ExecutorWrapper)vv, (List)DynamicTpConst.SCHEDULE_NOTIFY_ITEMS));
        });
    }
}

