/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.spring;

import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.env.Environment;

public class ApplicationContextHolder
implements ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)ApplicationContextHolder.getInstance().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)ApplicationContextHolder.getInstance().getBean(name, clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return ApplicationContextHolder.getInstance().getBeansOfType(clazz);
    }

    public static ApplicationContext getInstance() {
        if (Objects.isNull(context)) {
            throw new NullPointerException("ApplicationContext is null, please check if the spring container is started.");
        }
        return context;
    }

    public static Environment getEnvironment() {
        return ApplicationContextHolder.getInstance().getEnvironment();
    }

    public static void publishEvent(ApplicationEvent event) {
        ApplicationContextHolder.getInstance().publishEvent(event);
    }
}

