/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexUtil;
import org.drools.model.Index;
import org.drools.model.functions.Function1;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;

public class UnificationConstraint
extends MutableTypeConstraint
implements IndexableConstraint {
    private final Declaration declaration;
    private final InternalReadAccessor readAccessor;
    private final ConstraintEvaluator evaluator;
    private boolean unification = true;

    public UnificationConstraint(Declaration declaration) {
        this(declaration, null);
    }

    public UnificationConstraint(Declaration declaration, ConstraintEvaluator evaluator) {
        this.declaration = declaration;
        this.evaluator = evaluator;
        if (evaluator != null) {
            Index index = evaluator.getIndex();
            this.readAccessor = new LambdaReadAccessor(index.getIndexId(), index.getIndexedClass(), index.getLeftOperandExtractor());
        } else {
            this.readAccessor = new LambdaReadAccessor(declaration.getDeclarationClass(), (Function1 & Serializable)x -> x);
        }
    }

    public boolean isUnification() {
        return this.unification;
    }

    public void unsetUnification() {
        this.unification = false;
    }

    public boolean isIndexable(short nodeType) {
        return true;
    }

    public IndexUtil.ConstraintType getConstraintType() {
        return IndexUtil.ConstraintType.EQUAL;
    }

    public FieldValue getField() {
        throw new UnsupportedOperationException();
    }

    public AbstractHashTable.FieldIndex getFieldIndex() {
        return new AbstractHashTable.FieldIndex(this.readAccessor, this.declaration, MvelConstraint.INDEX_EVALUATOR);
    }

    public InternalReadAccessor getFieldExtractor() {
        return this.readAccessor;
    }

    public Declaration[] getRequiredDeclarations() {
        return new Declaration[]{this.declaration};
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.evaluator == null) {
            throw new UnsupportedOperationException();
        }
        this.evaluator.replaceDeclaration(oldDecl, newDecl);
    }

    public MutableTypeConstraint clone() {
        return new UnificationConstraint(this.declaration, this.evaluator);
    }

    public boolean isTemporal() {
        return false;
    }

    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return this.evaluateUnification(handle, ((LambdaConstraint.LambdaContextEntry)context).getTuple(), ((LambdaConstraint.LambdaContextEntry)context).getWorkingMemory());
    }

    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        return this.evaluateUnification(((LambdaConstraint.LambdaContextEntry)context).getHandle(), tuple, ((LambdaConstraint.LambdaContextEntry)context).getWorkingMemory());
    }

    private boolean evaluateUnification(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        if (!this.unification) {
            return this.evaluator.evaluate(handle, tuple, workingMemory);
        }
        DroolsQuery query = (DroolsQuery)tuple.getObject(0);
        if (query.getVariables()[this.declaration.getExtractor().getIndex()] != null) {
            return true;
        }
        if (this.evaluator != null) {
            return this.evaluator.evaluate(handle, tuple, workingMemory);
        }
        Object argument = this.declaration.getValue(null, (Object)query);
        return handle.getObject().equals(argument);
    }

    public ContextEntry createContextEntry() {
        return new LambdaConstraint.LambdaContextEntry();
    }
}

