/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.maven.plugin.JettyRunMojo;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyEffectiveWebXml
extends JettyRunMojo {
    protected File target;
    protected File effectiveWebXml;
    protected boolean deleteOnExit = true;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    @Override
    public void startJetty() throws MojoExecutionException {
        if (this.effectiveWebXml == null) {
            this.deleteOnExit = true;
            this.effectiveWebXml = new File(this.target, "effective-web.xml");
            this.effectiveWebXml.deleteOnExit();
        }
        Resource descriptor = Resource.newResource((File)this.effectiveWebXml);
        QueuedThreadPool tpool = null;
        try {
            this.printSystemProperties();
            this.applyJettyXml();
            this.server.configureHandlers();
            this.configureWebApplication();
            this.webApp.setCopyWebDir(false);
            this.webApp.setCopyWebInf(false);
            this.webApp.setGenerateQuickStart(true);
            if (!this.effectiveWebXml.getParentFile().exists()) {
                this.effectiveWebXml.getParentFile().mkdirs();
            }
            if (!this.effectiveWebXml.exists()) {
                this.effectiveWebXml.createNewFile();
            }
            this.webApp.setQuickStartWebDescriptor(descriptor);
            this.server.addWebApplication(this.webApp);
            tpool = (QueuedThreadPool)this.server.getBean(QueuedThreadPool.class);
            if (tpool != null) {
                tpool.start();
            } else {
                this.webApp.setAttribute("org.eclipse.jetty.annotations.multiThreaded", Boolean.FALSE.toString());
            }
            this.webApp.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Effective web.xml generation failed", e);
        }
        finally {
            try {
                this.webApp.stop();
            }
            catch (Exception exception) {}
            try {
                if (tpool != null) {
                    tpool.stop();
                }
            }
            catch (Exception exception) {}
        }
        if (this.deleteOnExit) {
            try {
                this.getLog().info((CharSequence)IO.toString((InputStream)descriptor.getInputStream()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to output effective web.xml", (Exception)e);
            }
        }
    }
}

