/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

public final class ConfigSpec {
    public static final ConfigSpec GLOBAL = new ConfigSpec(null, null, null);
    private final String ws;
    private final String os;
    private final String arch;

    public static ConfigSpec createFromWsOsArch(String wsOsArchDotSeparated) {
        if (wsOsArchDotSeparated.equals("")) {
            return GLOBAL;
        }
        return new ConfigSpec(wsOsArchDotSeparated.split("\\."));
    }

    public static ConfigSpec createFromOsWsArchArray(String[] segments, int beginIndex) {
        return new ConfigSpec(segments[beginIndex + 1], segments[beginIndex], segments[beginIndex + 2]);
    }

    private ConfigSpec(String[] wsOsArch) {
        this.ws = wsOsArch[0];
        this.os = wsOsArch[1];
        this.arch = wsOsArch[2];
    }

    private ConfigSpec(String ws, String os, String arch) {
        this.ws = ws;
        this.os = os;
        this.arch = arch;
    }

    public int hashCode() {
        int prime = 29;
        int result = 1;
        result = 29 * result + (this.arch == null ? 0 : this.arch.hashCode());
        result = 29 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 29 * result + (this.ws == null ? 0 : this.ws.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConfigSpec) {
            ConfigSpec other = (ConfigSpec)obj;
            return this.equals(this.ws, other.ws) && this.equals(this.os, other.os) && this.equals(this.arch, other.arch);
        }
        return false;
    }

    private <T> boolean equals(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public String toOsString() {
        return String.valueOf(this.os) + '.' + this.ws + '.' + this.arch;
    }

    public String toStringForAdvice() {
        if (this.equals(GLOBAL)) {
            return "";
        }
        return String.valueOf(this.ws) + '.' + this.os + '.' + this.arch;
    }
}

