/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;

public class SystemMenuFastViewOrientation
extends ContributionItem {
    private PartPane viewPane;
    private IntModel currentOrientation = new IntModel(512);

    public SystemMenuFastViewOrientation(PartPane newViewPane) {
        this.viewPane = newViewPane;
        this.currentOrientation.addChangeListener(new IChangeListener(){

            public void update(boolean changed) {
                IWorkbenchPartReference ref;
                WorkbenchWindow workbenchWindow;
                FastViewBar bar;
                if (changed && (bar = (workbenchWindow = (WorkbenchWindow)SystemMenuFastViewOrientation.this.viewPane.getPage().getWorkbenchWindow()).getFastViewBar()) != null && SystemMenuFastViewOrientation.this.viewPane != null && (ref = SystemMenuFastViewOrientation.this.viewPane.getPartReference()) instanceof IViewReference) {
                    bar.setOrientation((IViewReference)ref, SystemMenuFastViewOrientation.this.currentOrientation.get());
                }
            }
        });
    }

    public void dispose() {
        this.viewPane = null;
    }

    public void fill(Menu menu, int index) {
        IWorkbenchPartReference ref;
        FastViewBar bar;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.viewPane.getPage().getWorkbenchWindow();
        if (this.viewPane.getPartReference() instanceof IViewReference) {
            boolean realFV;
            IViewReference viewRef = (IViewReference)this.viewPane.getPartReference();
            Perspective persp = this.viewPane.getPage().getActivePerspective();
            FastViewManager fvm = persp.getFastViewManager();
            String trimId = null;
            if (fvm != null) {
                trimId = fvm.getIdForRef(viewRef);
            }
            boolean bl = realFV = trimId == null || FastViewBar.FASTVIEWBAR_ID.equals(trimId);
            if (!realFV) {
                return;
            }
        }
        if ((bar = workbenchWindow.getFastViewBar()) != null && this.viewPane != null && (ref = this.viewPane.getPartReference()) instanceof IViewReference) {
            this.currentOrientation.set(bar.getOrientation((IViewReference)ref));
            MenuItem orientationItem = new MenuItem(menu, 64, index);
            orientationItem.setText(WorkbenchMessages.FastViewBar_view_orientation);
            Menu orientationSwtMenu = new Menu(orientationItem);
            RadioMenu orientationMenu = new RadioMenu(orientationSwtMenu, this.currentOrientation);
            orientationMenu.addMenuItem(WorkbenchMessages.FastViewBar_horizontal, new Integer(256));
            orientationMenu.addMenuItem(WorkbenchMessages.FastViewBar_vertical, new Integer(512));
            orientationItem.setMenu(orientationSwtMenu);
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

