/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel.cdi;

import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.commons.lang3.StringUtils;
import org.flowable.camel.CamelBehavior;
import org.flowable.cdi.impl.util.BeanManagerLookup;
import org.flowable.cdi.impl.util.ProgrammaticBeanLookup;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;

public abstract class CdiCamelBehavior
extends CamelBehavior {
    private static final long serialVersionUID = 1L;

    protected void setAppropriateCamelContext(DelegateExecution execution) {
        String camelContextValue = this.getStringFromField(this.camelContext, execution);
        if (!StringUtils.isEmpty((CharSequence)camelContextValue) || this.camelContextObj == null) {
            ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
            if (StringUtils.isEmpty((CharSequence)camelContextValue) && this.camelContextObj == null) {
                camelContextValue = engineConfiguration.getDefaultCamelContext();
            }
            this.camelContextObj = this.get(camelContextValue);
            if (this.camelContextObj == null && camelContextValue.equals(engineConfiguration.getDefaultCamelContext())) {
                this.camelContextObj = (CamelContext)ProgrammaticBeanLookup.lookup(CamelContext.class);
            }
        }
    }

    protected CamelContext get(String name) {
        BeanManager beanManager = BeanManagerLookup.getBeanManager();
        Set beans = beanManager.getBeans(name);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        return (CamelContext)beanManager.getReference(bean, CamelContext.class, ctx);
    }
}

