/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Process;
import org.flowable.camel.ExchangeUtils;
import org.flowable.camel.FlowableEndpoint;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public abstract class CamelBehavior
extends AbstractBpmnActivityBehavior
implements ActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected Expression camelContext;
    protected CamelContext camelContextObj;
    protected List<MapExceptionEntry> mapExceptions;
    protected TargetType toTargetType;

    protected abstract void setPropertTargetVariable(FlowableEndpoint var1);

    protected void updateTargetVariables(FlowableEndpoint endpoint) {
        this.toTargetType = null;
        if (endpoint.isCopyVariablesToBodyAsMap()) {
            this.toTargetType = TargetType.BODY_AS_MAP;
        } else if (endpoint.isCopyCamelBodyToBody()) {
            this.toTargetType = TargetType.BODY;
        } else if (endpoint.isCopyVariablesToProperties()) {
            this.toTargetType = TargetType.PROPERTIES;
        }
        if (this.toTargetType == null) {
            this.setPropertTargetVariable(endpoint);
        }
    }

    protected void copyVariables(Map<String, Object> variables, Exchange exchange, FlowableEndpoint endpoint) {
        switch (this.toTargetType) {
            case BODY_AS_MAP: {
                this.copyVariablesToBodyAsMap(variables, exchange);
                break;
            }
            case BODY: {
                this.copyVariablesToBody(variables, exchange);
                break;
            }
            case PROPERTIES: {
                this.copyVariablesToProperties(variables, exchange);
            }
        }
    }

    public void execute(DelegateExecution execution) {
        this.setAppropriateCamelContext(execution);
        FlowableEndpoint endpoint = this.createEndpoint(execution);
        Exchange exchange = this.createExchange(execution, endpoint);
        try {
            endpoint.process(exchange);
        }
        catch (Exception e) {
            throw new FlowableException("Exception while processing exchange", (Throwable)e);
        }
        execution.setVariables(ExchangeUtils.prepareVariables(exchange, endpoint));
        boolean isV5Execution = false;
        if (Context.getCommandContext() != null && Flowable5Util.isFlowable5ProcessDefinitionId((CommandContext)Context.getCommandContext(), (String)execution.getProcessDefinitionId()) || Context.getCommandContext() == null && Flowable5Util.getFlowable5CompatibilityHandler() != null) {
            isV5Execution = true;
        }
        if (!this.handleCamelException(exchange, execution, isV5Execution)) {
            if (isV5Execution) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.leaveExecution(execution);
                return;
            }
            this.leave(execution);
        }
    }

    protected FlowableEndpoint createEndpoint(DelegateExecution execution) {
        String uri = "flowable://" + this.getProcessDefinitionKey(execution) + ":" + execution.getCurrentActivityId();
        return this.getEndpoint(uri);
    }

    protected FlowableEndpoint getEndpoint(String key) {
        for (Endpoint e : this.camelContextObj.getEndpoints()) {
            if (!e.getEndpointKey().equals(key) || !(e instanceof FlowableEndpoint)) continue;
            return (FlowableEndpoint)e;
        }
        throw new FlowableException("Endpoint not defined for " + key);
    }

    protected Exchange createExchange(DelegateExecution activityExecution, FlowableEndpoint endpoint) {
        Exchange ex = endpoint.createExchange();
        ex.setProperty("PROCESS_ID_PROPERTY", (Object)activityExecution.getProcessInstanceId());
        ex.setProperty("EXECUTION_ID_PROPERTY", (Object)activityExecution.getId());
        Map variables = activityExecution.getVariables();
        this.updateTargetVariables(endpoint);
        this.copyVariables(variables, ex, endpoint);
        return ex;
    }

    protected boolean handleCamelException(Exchange exchange, DelegateExecution execution, boolean isV5Execution) {
        boolean notHandledByCamel;
        Exception camelException = exchange.getException();
        boolean bl = notHandledByCamel = exchange.isFailed() && camelException != null;
        if (notHandledByCamel) {
            if (camelException instanceof BpmnError) {
                if (isV5Execution) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.propagateError((BpmnError)camelException, execution);
                    return true;
                }
                ErrorPropagation.propagateError((BpmnError)((BpmnError)camelException), (DelegateExecution)execution);
                return true;
            }
            if (isV5Execution) {
                Flowable5CompatibilityHandler ompatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                if (ompatibilityHandler.mapException(camelException, execution, this.mapExceptions)) {
                    return true;
                }
                throw new FlowableException("Unhandled exception on camel route", (Throwable)camelException);
            }
            if (ErrorPropagation.mapException((Exception)camelException, (ExecutionEntity)((ExecutionEntity)execution), this.mapExceptions)) {
                return true;
            }
            throw new FlowableException("Unhandled exception on camel route", (Throwable)camelException);
        }
        return false;
    }

    protected void copyVariablesToProperties(Map<String, Object> variables, Exchange exchange) {
        for (Map.Entry<String, Object> var : variables.entrySet()) {
            exchange.setProperty(var.getKey(), var.getValue());
        }
    }

    protected void copyVariablesToBodyAsMap(Map<String, Object> variables, Exchange exchange) {
        exchange.getIn().setBody(new HashMap<String, Object>(variables));
    }

    protected void copyVariablesToBody(Map<String, Object> variables, Exchange exchange) {
        Object camelBody = variables.get("camelBody");
        if (camelBody != null) {
            exchange.getIn().setBody(camelBody);
        }
    }

    protected String getProcessDefinitionKey(DelegateExecution execution) {
        Process process = ProcessDefinitionUtil.getProcess((String)execution.getProcessDefinitionId());
        return process.getId();
    }

    protected boolean isASync(DelegateExecution execution) {
        boolean async = false;
        if (execution.getCurrentFlowElement() instanceof Activity) {
            async = ((Activity)execution.getCurrentFlowElement()).isAsynchronous();
        }
        return async;
    }

    protected abstract void setAppropriateCamelContext(DelegateExecution var1);

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableContainer)execution)) != null) {
            return value.toString();
        }
        return null;
    }

    public void setCamelContext(Expression camelContext) {
        this.camelContext = camelContext;
    }

    public static enum TargetType {
        BODY_AS_MAP,
        BODY,
        PROPERTIES;

    }
}

