/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl.context;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.flowable.cdi.BusinessProcess;
import org.flowable.cdi.annotation.BusinessProcessScoped;
import org.flowable.cdi.impl.util.ProgrammaticBeanLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessProcessContext
implements Context {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BusinessProcessContext.class);
    private final BeanManager beanManager;

    public BusinessProcessContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected BusinessProcess getBusinessProcess() {
        return ProgrammaticBeanLookup.lookup(BusinessProcess.class, this.beanManager);
    }

    public Class<? extends Annotation> getScope() {
        return BusinessProcessScoped.class;
    }

    public <T> T get(Contextual<T> contextual) {
        Bean bean = (Bean)contextual;
        String variableName = bean.getName();
        BusinessProcess businessProcess = this.getBusinessProcess();
        Object variable = businessProcess.getVariable(variableName);
        if (variable != null) {
            if (LOGGER.isDebugEnabled()) {
                if (businessProcess.isAssociated()) {
                    LOGGER.debug("Getting instance of bean '{}' from Execution[{}]", (Object)variableName, (Object)businessProcess.getExecutionId());
                } else {
                    LOGGER.debug("Getting instance of bean '{}' from transient bean store", (Object)variableName);
                }
            }
            return variable;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> arg1) {
        Bean bean = (Bean)contextual;
        String variableName = bean.getName();
        BusinessProcess businessProcess = this.getBusinessProcess();
        Object variable = businessProcess.getVariable(variableName);
        if (variable != null) {
            if (LOGGER.isDebugEnabled()) {
                if (businessProcess.isAssociated()) {
                    LOGGER.debug("Getting instance of bean '{}' from Execution[{}]", (Object)variableName, (Object)businessProcess.getExecutionId());
                } else {
                    LOGGER.debug("Getting instance of bean '{}' from transient bean store", (Object)variableName);
                }
            }
            return variable;
        }
        if (LOGGER.isDebugEnabled()) {
            if (businessProcess.isAssociated()) {
                LOGGER.debug("Creating instance of bean '{}' in business process context representing Execution[{}]", (Object)variableName, (Object)businessProcess.getExecutionId());
            } else {
                LOGGER.debug("Creating instance of bean '{}' in transient bean store", (Object)variableName);
            }
        }
        Object beanInstance = bean.create(arg1);
        businessProcess.setVariable(variableName, beanInstance);
        return (T)beanInstance;
    }

    public boolean isActive() {
        return true;
    }
}

