/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl;

import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.CmmnEngines;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnEngineImpl
implements CmmnEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnEngineImpl.class);
    protected String name;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnRuntimeService cmmnRuntimeService;
    protected CmmnTaskService cmmnTaskService;
    protected CmmnManagementService cmmnManagementService;
    protected CmmnRepositoryService cmmnRepositoryService;
    protected CmmnHistoryService cmmnHistoryService;
    protected AsyncExecutor asyncExecutor;
    protected AsyncExecutor asyncHistoryExecutor;

    public CmmnEngineImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
        this.name = cmmnEngineConfiguration.getEngineName();
        this.cmmnRuntimeService = cmmnEngineConfiguration.getCmmnRuntimeService();
        this.cmmnTaskService = cmmnEngineConfiguration.getCmmnTaskService();
        this.cmmnManagementService = cmmnEngineConfiguration.getCmmnManagementService();
        this.cmmnRepositoryService = cmmnEngineConfiguration.getCmmnRepositoryService();
        this.cmmnHistoryService = cmmnEngineConfiguration.getCmmnHistoryService();
        this.asyncExecutor = cmmnEngineConfiguration.getAsyncExecutor();
        this.asyncHistoryExecutor = cmmnEngineConfiguration.getAsyncHistoryExecutor();
        if (cmmnEngineConfiguration.getSchemaManagementCmd() != null) {
            CommandExecutor commandExecutor = cmmnEngineConfiguration.getCommandExecutor();
            commandExecutor.execute(cmmnEngineConfiguration.getSchemaCommandConfig(), cmmnEngineConfiguration.getSchemaManagementCmd());
        }
        if (this.asyncExecutor != null && this.asyncExecutor.isAutoActivate()) {
            this.asyncExecutor.start();
        }
        if (this.asyncHistoryExecutor != null && this.asyncHistoryExecutor.isAutoActivate()) {
            this.asyncHistoryExecutor.start();
        }
        if (cmmnEngineConfiguration.isEnableHistoryCleaning()) {
            this.cmmnManagementService.handleHistoryCleanupTimerJob();
        }
        LOGGER.info("CmmnEngine {} created", (Object)this.name);
        CmmnEngines.registerCmmnEngine(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void close() {
        CmmnEngines.unregister(this);
        if (this.asyncExecutor != null && this.asyncExecutor.isActive()) {
            this.asyncExecutor.shutdown();
        }
        if (this.asyncHistoryExecutor != null && this.asyncHistoryExecutor.isActive()) {
            this.asyncHistoryExecutor.shutdown();
        }
        this.cmmnEngineConfiguration.close();
    }

    @Override
    public CmmnEngineConfiguration getCmmnEngineConfiguration() {
        return this.cmmnEngineConfiguration;
    }

    public void setCmmnEngineConfiguration(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    @Override
    public CmmnRuntimeService getCmmnRuntimeService() {
        return this.cmmnRuntimeService;
    }

    public void setCmmnRuntimeService(CmmnRuntimeService cmmnRuntimeService) {
        this.cmmnRuntimeService = cmmnRuntimeService;
    }

    @Override
    public CmmnTaskService getCmmnTaskService() {
        return this.cmmnTaskService;
    }

    public void setCmmnTaskService(CmmnTaskService cmmnTaskService) {
        this.cmmnTaskService = cmmnTaskService;
    }

    @Override
    public CmmnManagementService getCmmnManagementService() {
        return this.cmmnManagementService;
    }

    public void setCmmnManagementService(CmmnManagementService cmmnManagementService) {
        this.cmmnManagementService = cmmnManagementService;
    }

    @Override
    public CmmnRepositoryService getCmmnRepositoryService() {
        return this.cmmnRepositoryService;
    }

    public void setCmmnRepositoryService(CmmnRepositoryService cmmnRepositoryService) {
        this.cmmnRepositoryService = cmmnRepositoryService;
    }

    @Override
    public CmmnHistoryService getCmmnHistoryService() {
        return this.cmmnHistoryService;
    }

    public void setCmmnHistoryService(CmmnHistoryService cmmnHistoryService) {
        this.cmmnHistoryService = cmmnHistoryService;
    }
}

