/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractPlanItemInstanceHistoryJsonTransformer;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class PlanItemInstanceFullHistoryJsonTransformer
extends AbstractPlanItemInstanceHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("cmmn-plan-item-instance-full");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity = this.getHistoricPlanItemInstanceEntity(historicalData, commandContext);
        if (historicPlanItemInstanceEntity == null) {
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = CommandContextUtil.getHistoricPlanItemInstanceEntityManager(commandContext);
            historicPlanItemInstanceEntity = (HistoricPlanItemInstanceEntity)historicPlanItemInstanceEntityManager.create();
            this.copyCommonPlanItemInstanceProperties(historicPlanItemInstanceEntity, historicalData);
            historicPlanItemInstanceEntityManager.insert(historicPlanItemInstanceEntity);
        } else {
            Date lastUpdateTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastUpdateTime");
            if (lastUpdateTime != null && (historicPlanItemInstanceEntity.getLastUpdatedTime() == null || lastUpdateTime.after(historicPlanItemInstanceEntity.getLastUpdatedTime()))) {
                this.copyCommonPlanItemInstanceProperties(historicPlanItemInstanceEntity, historicalData);
                CommandContextUtil.getHistoricPlanItemInstanceEntityManager(commandContext).update(historicPlanItemInstanceEntity);
            }
        }
    }

    @Override
    protected void copyCommonPlanItemInstanceProperties(HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity, ObjectNode historicalData) {
        super.copyCommonPlanItemInstanceProperties(historicPlanItemInstanceEntity, historicalData);
        historicPlanItemInstanceEntity.setLastAvailableTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastAvailableTime"));
        historicPlanItemInstanceEntity.setLastEnabledTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastEnabledTime"));
        historicPlanItemInstanceEntity.setLastDisabledTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastDisabledTime"));
        historicPlanItemInstanceEntity.setLastStartedTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastStartedTime"));
        historicPlanItemInstanceEntity.setLastSuspendedTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastSuspendedTime"));
        historicPlanItemInstanceEntity.setCompletedTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"completedTime"));
        historicPlanItemInstanceEntity.setOccurredTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"occurredTime"));
        historicPlanItemInstanceEntity.setTerminatedTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"terminatedTime"));
        historicPlanItemInstanceEntity.setExitTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"exitTime"));
        historicPlanItemInstanceEntity.setEndedTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime"));
    }

    protected HistoricPlanItemInstanceEntity getHistoricPlanItemInstanceEntity(ObjectNode historicalData, CommandContext commandContext) {
        return (HistoricPlanItemInstanceEntity)CommandContextUtil.getHistoricPlanItemInstanceEntityManager(commandContext).findById(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
    }
}

