/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test;

import java.io.IOException;
import java.io.InputStream;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.AbstractFlowableCmmnTestCase;
import org.flowable.cmmn.engine.test.impl.CmmnTestRunner;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowableCmmnTestCase
extends AbstractFlowableCmmnTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCmmnTestCase.class);
    public static String FLOWABLE_CMMN_CFG_XML = "flowable.cmmn.cfg.xml";

    @BeforeClass
    public static void setupEngine() {
        if (CmmnTestRunner.getCmmnEngineConfiguration() == null) {
            FlowableCmmnTestCase.initCmmnEngine();
        }
    }

    protected static void initCmmnEngine() {
        try (InputStream inputStream = FlowableCmmnTestCase.class.getClassLoader().getResourceAsStream(FLOWABLE_CMMN_CFG_XML);){
            if (inputStream == null) {
                throw new RuntimeException("No " + FLOWABLE_CMMN_CFG_XML + " file found on the classpath");
            }
            cmmnEngine = CmmnEngineConfiguration.createCmmnEngineConfigurationFromInputStream(inputStream).buildCmmnEngine();
            CmmnTestRunner.setCmmnEngineConfiguration(cmmnEngine.getCmmnEngineConfiguration());
        }
        catch (IOException e) {
            LOGGER.error("Could not create CMMN engine", (Throwable)e);
        }
    }

    @Before
    public void setupServices() {
        CmmnEngineConfiguration cmmnEngineConfiguration;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration = CmmnTestRunner.getCmmnEngineConfiguration();
        this.cmmnRepositoryService = cmmnEngineConfiguration.getCmmnRepositoryService();
        this.cmmnManagementService = cmmnEngineConfiguration.getCmmnManagementService();
        this.cmmnRuntimeService = cmmnEngineConfiguration.getCmmnRuntimeService();
        this.cmmnTaskService = cmmnEngineConfiguration.getCmmnTaskService();
        this.cmmnHistoryService = cmmnEngineConfiguration.getCmmnHistoryService();
    }
}

