/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.exception.FlowableContentNotSupportedException;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BaseVariableResource {
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected CmmnRuntimeService runtimeService;
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;
    @Autowired
    protected Environment env;
    protected boolean isSerializableVariableAllowed;

    @PostConstruct
    protected void postConstruct() {
        this.isSerializableVariableAllowed = (Boolean)this.env.getProperty("rest.variables.allow.serializable", Boolean.class, (Object)true);
    }

    protected CaseInstance getCaseInstanceFromRequest(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a case instance with id '" + caseInstanceId + "'.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessCaseInstanceInfoById(caseInstance);
        }
        return caseInstance;
    }

    public RestVariable getVariableFromRequest(CaseInstance caseInstance, String variableName, boolean includeBinary) {
        Object value = null;
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a case instance", CaseInstance.class);
        }
        value = this.runtimeService.getVariable(caseInstance.getId(), variableName);
        if (value == null) {
            throw new FlowableObjectNotFoundException("Case instance '" + caseInstance.getId() + "' doesn't have a variable with name: '" + variableName + "'.", VariableInstanceEntity.class);
        }
        return this.constructRestVariable(variableName, value, caseInstance.getId(), includeBinary);
    }

    protected byte[] getVariableDataByteArray(CaseInstance caseInstance, String variableName, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(caseInstance, variableName, true);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Error getting variable " + variableName, (Throwable)ioe);
        }
    }

    protected RestVariable constructRestVariable(String variableName, Object value, String caseInstanceId, boolean includeBinary) {
        return this.restResponseFactory.createRestVariable(variableName, value, null, caseInstanceId, 3, includeBinary);
    }

    protected List<RestVariable> processCaseVariables(CaseInstance caseInstance, int variableType) {
        ArrayList<RestVariable> result = new ArrayList<RestVariable>();
        List<RestVariable> variables = this.addVariables(caseInstance, variableType);
        result.addAll(variables);
        return result;
    }

    protected Object createVariable(CaseInstance caseInstance, int variableType, HttpServletRequest request, HttpServletResponse response) {
        Object result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, caseInstance, variableType, true);
        } else {
            ArrayList<RestVariable> inputVariables = new ArrayList<RestVariable>();
            ArrayList<RestVariable> resultVariables = new ArrayList<RestVariable>();
            result = resultVariables;
            try {
                List variableObjects = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), List.class);
                for (Object restObject : variableObjects) {
                    RestVariable restVariable = (RestVariable)((Object)this.objectMapper.convertValue(restObject, RestVariable.class));
                    inputVariables.add(restVariable);
                }
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("Failed to serialize to a RestVariable instance", (Throwable)e);
            }
            if (inputVariables == null || inputVariables.size() == 0) {
                throw new FlowableIllegalArgumentException("Request didn't contain a list of variables to create.");
            }
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : inputVariables) {
                if (var.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
                resultVariables.add(this.restResponseFactory.createRestVariable(var.getName(), actualVariableValue, RestVariable.RestVariableScope.GLOBAL, caseInstance.getId(), variableType, false));
            }
            if (!variablesToSet.isEmpty()) {
                this.runtimeService.setVariables(caseInstance.getId(), variablesToSet);
            }
        }
        response.setStatus(HttpStatus.CREATED.value());
        return result;
    }

    protected List<RestVariable> addVariables(CaseInstance caseInstance, int variableType) {
        Map rawVariables = this.runtimeService.getVariables(caseInstance.getId());
        return this.restResponseFactory.createRestVariables(rawVariables, caseInstance.getId(), variableType);
    }

    public void deleteAllVariables(CaseInstance caseInstance, HttpServletResponse response) {
        Set currentVariables = this.runtimeService.getVariables(caseInstance.getId()).keySet();
        this.runtimeService.removeVariables(caseInstance.getId(), currentVariables);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected RestVariable setSimpleVariable(RestVariable restVariable, CaseInstance caseInstance, boolean isNew) {
        if (restVariable.getName() == null) {
            throw new FlowableIllegalArgumentException("Variable name is required");
        }
        Object actualVariableValue = this.restResponseFactory.getVariableValue(restVariable);
        this.setVariable(caseInstance, restVariable.getName(), actualVariableValue, null, isNew);
        return this.constructRestVariable(restVariable.getName(), actualVariableValue, caseInstance.getId(), false);
    }

    protected RestVariable setBinaryVariable(MultipartHttpServletRequest request, CaseInstance caseInstance, int responseVariableType, boolean isNew) {
        if (request.getFileMap().size() == 0) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        MultipartFile file = request.getFile((String)request.getFileMap().keySet().iterator().next());
        if (file == null) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        String variableScope = null;
        String variableName = null;
        String variableType = null;
        Map paramMap = request.getParameterMap();
        for (String parameterName : paramMap.keySet()) {
            if (((String[])paramMap.get(parameterName)).length <= 0) continue;
            if (parameterName.equalsIgnoreCase("scope")) {
                variableScope = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (parameterName.equalsIgnoreCase("name")) {
                variableName = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (!parameterName.equalsIgnoreCase("type")) continue;
            variableType = ((String[])paramMap.get(parameterName))[0];
        }
        try {
            if (variableName == null) {
                throw new FlowableIllegalArgumentException("No variable name was found in request body.");
            }
            if (variableType != null) {
                if (!"binary".equals(variableType) && !"serializable".equals(variableType)) {
                    throw new FlowableIllegalArgumentException("Only 'binary' and 'serializable' are supported as variable type.");
                }
            } else {
                variableType = "binary";
            }
            RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
            if (variableScope != null) {
                scope = RestVariable.getScopeFromString(variableScope);
            }
            if (variableType.equals("binary")) {
                byte[] variableBytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                this.setVariable(caseInstance, variableName, (Object)variableBytes, scope, isNew);
            } else if (this.isSerializableVariableAllowed) {
                ObjectInputStream stream = new ObjectInputStream(file.getInputStream());
                Object value = stream.readObject();
                this.setVariable(caseInstance, variableName, value, scope, isNew);
                stream.close();
            } else {
                throw new FlowableContentNotSupportedException("Serialized objects are not allowed");
            }
            return this.restResponseFactory.createBinaryRestVariable(variableName, scope, variableType, null, caseInstance.getId());
        }
        catch (IOException ioe) {
            throw new FlowableIllegalArgumentException("Could not process multipart content", (Throwable)ioe);
        }
        catch (ClassNotFoundException ioe) {
            throw new FlowableContentNotSupportedException("The provided body contains a serialized object for which the class was not found: " + ioe.getMessage());
        }
    }

    protected void setVariable(CaseInstance caseInstance, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew) {
        this.runtimeService.setVariable(caseInstance.getId(), name, value);
    }

    protected void setVariable(PlanItemInstance planItemInstance, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew) {
        this.runtimeService.setVariable(planItemInstance.getCaseInstanceId(), name, value);
    }
}

