/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.editor.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.flowable.dmn.editor.constants.DmnStencilConstants;
import org.flowable.dmn.editor.constants.EditorJsonConstants;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.model.GraphicInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnJsonConverterUtil
implements EditorJsonConstants,
DmnStencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnJsonConverterUtil.class);
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    protected static double lineWidth = 0.05;

    public static String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode jsonNode = objectNode.get(name);
        if (jsonNode != null && !jsonNode.isNull()) {
            propertyValue = jsonNode.asText();
        }
        return propertyValue;
    }

    public static boolean migrateModel(JsonNode decisionTableNode, ObjectMapper objectMapper) {
        boolean wasMigrated = false;
        if ((decisionTableNode.get("modelVersion") == null || decisionTableNode.get("modelVersion").isNull()) && decisionTableNode.has("name")) {
            wasMigrated = true;
            String modelName = decisionTableNode.get("name").asText();
            LOGGER.info("Decision table model with name {} found with version < v2; migrating to v3", (Object)modelName);
            ObjectNode decisionTableObjectNode = (ObjectNode)decisionTableNode;
            decisionTableObjectNode.put("modelVersion", "3");
            JsonNode inputExpressionNodes = decisionTableNode.get("inputExpressions");
            HashMap<String, String> inputExpressionIds = new HashMap<String, String>();
            if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                for (JsonNode inputExpressionNode : inputExpressionNodes) {
                    if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                    String inputId = inputExpressionNode.get("id").asText();
                    String inputType = null;
                    if (inputExpressionNode.get("type") != null && !inputExpressionNode.get("type").isNull()) {
                        inputType = inputExpressionNode.get("type").asText();
                    }
                    inputExpressionIds.put(inputId, inputType);
                }
            }
            JsonNode ruleNodes = decisionTableNode.get("rules");
            ArrayNode newRuleNodes = objectMapper.createArrayNode();
            if (ruleNodes != null && !ruleNodes.isNull()) {
                for (JsonNode ruleNode : ruleNodes) {
                    ObjectNode newRuleNode = objectMapper.createObjectNode();
                    for (String inputExpressionId : inputExpressionIds.keySet()) {
                        String oldExpression;
                        if (!ruleNode.has(inputExpressionId)) continue;
                        String operatorId = inputExpressionId + "_operator";
                        String expressionId = inputExpressionId + "_expression";
                        String operatorValue = null;
                        String expressionValue = null;
                        if (ruleNode.get(inputExpressionId) != null && !ruleNode.get(inputExpressionId).isNull() && StringUtils.isNotEmpty((CharSequence)(oldExpression = ruleNode.get(inputExpressionId).asText()))) {
                            if (oldExpression.indexOf(32) != -1) {
                                operatorValue = oldExpression.substring(0, oldExpression.indexOf(32));
                                expressionValue = oldExpression.substring(oldExpression.indexOf(32) + 1);
                            } else {
                                expressionValue = oldExpression;
                            }
                            if (expressionValue.startsWith("\"") && expressionValue.endsWith("\"")) {
                                expressionValue = expressionValue.substring(1, expressionValue.length() - 1);
                            }
                            if (expressionValue.startsWith("fn_date(")) {
                                expressionValue = expressionValue.substring(9, expressionValue.lastIndexOf(39));
                            } else if (expressionValue.startsWith("date:toDate(")) {
                                expressionValue = expressionValue.substring(13, expressionValue.lastIndexOf(39));
                            }
                            if (StringUtils.isEmpty((CharSequence)((CharSequence)inputExpressionIds.get(inputExpressionId)))) {
                                String expressionType = DmnJsonConverterUtil.determineExpressionType(expressionValue);
                                inputExpressionIds.put(inputExpressionId, expressionType);
                            }
                        }
                        if (StringUtils.isNotEmpty(operatorValue)) {
                            newRuleNode.put(operatorId, operatorValue);
                        } else {
                            newRuleNode.put(operatorId, "==");
                        }
                        if (StringUtils.isNotEmpty(expressionValue)) {
                            newRuleNode.put(expressionId, expressionValue);
                            continue;
                        }
                        newRuleNode.put(expressionId, "-");
                    }
                    Iterator ruleProperty = ruleNode.fieldNames();
                    while (ruleProperty.hasNext()) {
                        String expressionId = (String)ruleProperty.next();
                        if (inputExpressionIds.containsKey(expressionId) || !ruleNode.hasNonNull(expressionId)) continue;
                        String expressionValue = ruleNode.get(expressionId).asText();
                        if (StringUtils.isNotEmpty((CharSequence)expressionValue) && expressionValue.startsWith("\"") && expressionValue.endsWith("\"")) {
                            expressionValue = expressionValue.substring(1, expressionValue.length() - 1);
                        }
                        if (expressionValue.startsWith("fn_date(")) {
                            expressionValue = expressionValue.substring(9, expressionValue.lastIndexOf(39));
                        } else if (expressionValue.startsWith("date:toDate(")) {
                            expressionValue = expressionValue.substring(13, expressionValue.lastIndexOf(39));
                        }
                        newRuleNode.put(expressionId, expressionValue);
                    }
                    newRuleNodes.add((JsonNode)newRuleNode);
                }
                if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                    for (JsonNode inputExpressionNode : inputExpressionNodes) {
                        if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                        String inputId = inputExpressionNode.get("id").asText();
                        ((ObjectNode)inputExpressionNode).put("type", (String)inputExpressionIds.get(inputId));
                    }
                }
                decisionTableObjectNode.replace("rules", (JsonNode)newRuleNodes);
            }
            LOGGER.info("Decision table model {} migrated to v3", (Object)modelName);
        }
        return wasMigrated;
    }

    public static boolean migrateModelV3(JsonNode decisionTableNode, ObjectMapper objectMapper) {
        boolean wasMigrated = DmnJsonConverterUtil.migrateModel(decisionTableNode, objectMapper);
        if (decisionTableNode.has("modelVersion") && "2".equals(decisionTableNode.get("modelVersion").asText()) && decisionTableNode.has("name")) {
            JsonNode ruleNodes;
            wasMigrated = true;
            String modelName = decisionTableNode.get("name").asText();
            LOGGER.info("Decision table model {} found with version v2; migrating to v3", (Object)modelName);
            ObjectNode decisionTableObjectNode = (ObjectNode)decisionTableNode;
            decisionTableObjectNode.put("modelVersion", "3");
            JsonNode inputExpressionNodes = decisionTableNode.get("inputExpressions");
            HashMap<String, String> inputExpressionIds = new HashMap<String, String>();
            if (inputExpressionNodes != null && !inputExpressionNodes.isNull()) {
                for (JsonNode inputExpressionNode : inputExpressionNodes) {
                    if (inputExpressionNode.get("id") == null || inputExpressionNode.get("id").isNull()) continue;
                    String inputId = inputExpressionNode.get("id").asText();
                    String inputType = null;
                    if (inputExpressionNode.get("type") != null && !inputExpressionNode.get("type").isNull()) {
                        inputType = inputExpressionNode.get("type").asText();
                    }
                    inputExpressionIds.put(inputId, inputType);
                }
            }
            if ((ruleNodes = decisionTableNode.get("rules")) != null && !ruleNodes.isNull()) {
                for (JsonNode ruleNode : ruleNodes) {
                    for (String inputExpressionId : inputExpressionIds.keySet()) {
                        String inputExpressionOperatorId = inputExpressionId + "_operator";
                        if (!ruleNode.has(inputExpressionOperatorId) || ruleNode.get(inputExpressionOperatorId) == null || ruleNode.get(inputExpressionOperatorId).isNull()) continue;
                        String oldInputExpressionOperatorValue = ruleNode.get(inputExpressionOperatorId).asText();
                        String inputType = (String)inputExpressionIds.get(inputExpressionId);
                        try {
                            String newInputExpressionOperatorValue = DmnJsonConverterUtil.transformCollectionOperation(oldInputExpressionOperatorValue, inputType);
                            ((ObjectNode)ruleNode).put(inputExpressionOperatorId, newInputExpressionOperatorValue);
                        }
                        catch (IllegalArgumentException iae) {
                            LOGGER.warn("Skipping model migration; could not transform collection operator for model name: {}", (Object)modelName, (Object)iae);
                        }
                    }
                }
            }
            LOGGER.info("Decision table model {} migrated to v3", (Object)modelName);
        }
        return wasMigrated;
    }

    public static String determineExpressionType(String expressionValue) {
        String expressionType;
        block5: {
            expressionType = null;
            if (!"-".equals(expressionValue)) {
                expressionType = "string";
                if (NumberUtils.isCreatable((String)expressionValue)) {
                    expressionType = "number";
                } else {
                    try {
                        new SimpleDateFormat("yyyy-MM-dd").parse(expressionValue);
                        expressionType = "date";
                    }
                    catch (ParseException pe) {
                        if (!"true".equalsIgnoreCase(expressionValue) && !"false".equalsIgnoreCase(expressionValue)) break block5;
                        expressionType = "boolean";
                    }
                }
            }
        }
        return expressionType;
    }

    public static String formatCollectionExpression(String containsOperator, String inputVariable, String expressionValue) {
        String containsPrefixAndMethod = DmnJsonConverterUtil.getDMNContainsExpressionMethod(containsOperator);
        StringBuilder stringBuilder = new StringBuilder();
        if (containsPrefixAndMethod != null) {
            stringBuilder.append("${");
            stringBuilder.append(containsPrefixAndMethod);
            stringBuilder.append("(");
            stringBuilder.append(DmnJsonConverterUtil.formatCollectionExpressionValue(inputVariable));
            stringBuilder.append(", ");
            String formattedExpressionValue = DmnJsonConverterUtil.formatCollectionExpressionValue(expressionValue);
            stringBuilder.append(formattedExpressionValue);
            stringBuilder.append(")}");
        } else {
            stringBuilder.append(containsOperator);
            stringBuilder.append(" ");
            stringBuilder.append(DmnJsonConverterUtil.formatCollectionExpressionValue(expressionValue));
        }
        return stringBuilder.toString();
    }

    public static boolean isCollectionOperator(String operator) {
        return "IN".equals(operator) || "NOT IN".equals(operator) || "ANY".equals(operator) || "NOT ANY".equals(operator) || "IS IN".equals(operator) || "IS NOT IN".equals(operator) || "NONE OF".equals(operator) || "NOT ALL OF".equals(operator) || "ALL OF".equals(operator);
    }

    public static boolean isDRD(JsonNode definitionNode) {
        return definitionNode.has("childShapes");
    }

    public static String getStencilId(JsonNode objectNode) {
        String stencilId = null;
        JsonNode stencilNode = objectNode.get("stencil");
        if (stencilNode != null && stencilNode.get("id") != null) {
            stencilId = stencilNode.get("id").asText();
        }
        return stencilId;
    }

    public static String getElementId(JsonNode objectNode) {
        String elementId = null;
        elementId = StringUtils.isNotEmpty((CharSequence)DmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode)) ? DmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode).trim() : objectNode.get("resourceId").asText();
        return elementId;
    }

    public static String getUniqueElementId() {
        return DmnJsonConverterUtil.getUniqueElementId(null);
    }

    public static String getUniqueElementId(String prefix) {
        UUID uuid = UUID.randomUUID();
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return uuid.toString();
        }
        return String.format("%s_%s", prefix, uuid);
    }

    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = DmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }

    public static ObjectNode createChildShape(String id, String type, double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode shapeNode = objectMapper.createObjectNode();
        shapeNode.set("bounds", (JsonNode)DmnJsonConverterUtil.createBoundsNode(lowerRightX, lowerRightY, upperLeftX, upperLeftY));
        shapeNode.put("resourceId", id);
        ArrayNode shapesArrayNode = objectMapper.createArrayNode();
        shapeNode.set("childShapes", (JsonNode)shapesArrayNode);
        ObjectNode stencilNode = objectMapper.createObjectNode();
        stencilNode.put("id", type);
        shapeNode.set("stencil", (JsonNode)stencilNode);
        shapeNode.putArray("outgoing");
        shapeNode.putArray("dockers");
        return shapeNode;
    }

    public static ObjectNode createBoundsNode(double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode boundsNode = objectMapper.createObjectNode();
        boundsNode.set("lowerRight", (JsonNode)DmnJsonConverterUtil.createPositionNode(lowerRightX, lowerRightY));
        boundsNode.set("upperLeft", (JsonNode)DmnJsonConverterUtil.createPositionNode(upperLeftX, upperLeftY));
        return boundsNode;
    }

    public static ObjectNode createPositionNode(double x, double y) {
        ObjectNode positionNode = objectMapper.createObjectNode();
        positionNode.put("x", x);
        positionNode.put("y", y);
        return positionNode;
    }

    public static Area createRectangle(GraphicInfo graphicInfo) {
        Area outerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX() + lineWidth, graphicInfo.getY() + lineWidth, graphicInfo.getWidth() - 2.0 * lineWidth, graphicInfo.getHeight() - 2.0 * lineWidth));
        outerRectangle.subtract(innerRectangle);
        return outerRectangle;
    }

    public static GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    public static Collection<Point2D> getIntersections(Line2D line, Area shape) {
        Area intersectionArea = new Area(DmnJsonConverterUtil.getLineShape(line));
        intersectionArea.intersect(shape);
        if (!intersectionArea.isEmpty()) {
            Rectangle2D bounds2D = intersectionArea.getBounds2D();
            HashSet<Point2D> intersections = new HashSet<Point2D>(1);
            intersections.add(new Point2D.Double(bounds2D.getX(), bounds2D.getY()));
            return intersections;
        }
        return Collections.EMPTY_SET;
    }

    public static Shape getLineShape(Line2D line2D) {
        Path2D.Double line = new Path2D.Double(1, 4);
        ((Path2D)line).moveTo(line2D.getX1(), line2D.getY1());
        ((Path2D)line).lineTo(line2D.getX2(), line2D.getY2());
        ((Path2D)line).lineTo(line2D.getX2() + lineWidth, line2D.getY2() + lineWidth);
        line.closePath();
        return line;
    }

    public static List<JsonLookupResult> getDmnModelChildShapesPropertyValues(JsonNode editorJsonNode, String propertyName, List<String> allowedStencilTypes) {
        ArrayList<JsonLookupResult> result = new ArrayList<JsonLookupResult>();
        DmnJsonConverterUtil.internalGetDmnChildShapePropertyValues(editorJsonNode, propertyName, allowedStencilTypes, result);
        return result;
    }

    public static List<JsonNode> filterOutJsonNodes(List<JsonLookupResult> lookupResults) {
        ArrayList<JsonNode> jsonNodes = new ArrayList<JsonNode>(lookupResults.size());
        for (JsonLookupResult lookupResult : lookupResults) {
            jsonNodes.add(lookupResult.getJsonNode());
        }
        return jsonNodes;
    }

    public static List<JsonLookupResult> getDmnModelDecisionTableReferences(ObjectNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("Decision");
        return DmnJsonConverterUtil.getDmnModelChildShapesPropertyValues((JsonNode)editorJsonNode, "decisiondecisiontablereference", allowedStencilTypes);
    }

    public static void updateDecisionTableModelReferences(ObjectNode decisionServiceObjectNode, DmnJsonConverterContext converterContext) {
        List<JsonNode> decisionTableNodes = DmnJsonConverterUtil.filterOutJsonNodes(DmnJsonConverterUtil.getDmnModelDecisionTableReferences(decisionServiceObjectNode));
        decisionTableNodes.forEach(decisionNode -> {
            String decisionTableKey = decisionNode.get("key").asText();
            Map<String, String> modelInfo = converterContext.getDecisionTableModelInfoForDecisionTableModelKey(decisionTableKey);
            if (modelInfo != null) {
                ((ObjectNode)decisionNode).put("id", modelInfo.get("id"));
            }
        });
    }

    protected static void internalGetDmnChildShapePropertyValues(JsonNode editorJsonNode, String propertyName, List<String> allowedStencilTypes, List<JsonLookupResult> result) {
        JsonNode childShapesNode = editorJsonNode.get("childShapes");
        if (childShapesNode != null && childShapesNode.isArray()) {
            ArrayNode childShapesArrayNode = (ArrayNode)childShapesNode;
            for (JsonNode childShapeNode : childShapesArrayNode) {
                JsonNode properties;
                String childShapeNodeStencilId = DmnJsonConverterUtil.getStencilId(childShapeNode);
                boolean readPropertiesNode = allowedStencilTypes.contains(childShapeNodeStencilId);
                if (readPropertiesNode && (properties = childShapeNode.get("properties")) != null && properties.has(propertyName)) {
                    JsonNode nameNode = properties.get("name");
                    JsonNode propertyNode = properties.get(propertyName);
                    result.add(new JsonLookupResult(DmnJsonConverterUtil.getElementId(childShapeNode), nameNode != null ? nameNode.asText() : null, propertyNode));
                }
                if (!childShapeNode.has("childShapes")) continue;
                DmnJsonConverterUtil.internalGetDmnChildShapePropertyValues(childShapeNode, propertyName, allowedStencilTypes, result);
            }
        }
    }

    protected static String getDMNContainsExpressionMethod(String containsOperator) {
        String containsPrefixAndMethod;
        if (StringUtils.isEmpty((CharSequence)containsOperator)) {
            throw new IllegalArgumentException("containsOperator must be provided");
        }
        switch (containsOperator) {
            case "IS IN": 
            case "ALL OF": 
            case "IN": {
                containsPrefixAndMethod = "collection:allOf";
                break;
            }
            case "IS NOT IN": 
            case "NONE OF": 
            case "NOT IN": {
                containsPrefixAndMethod = "collection:noneOf";
                break;
            }
            case "ANY OF": 
            case "ANY": {
                containsPrefixAndMethod = "collection:anyOf";
                break;
            }
            case "NOT ALL OF": 
            case "NOT ANY": {
                containsPrefixAndMethod = "collection:notAllOf";
                break;
            }
            default: {
                containsPrefixAndMethod = null;
            }
        }
        return containsPrefixAndMethod;
    }

    protected static String formatCollectionExpressionValue(String expressionValue) {
        if (StringUtils.isEmpty((CharSequence)expressionValue)) {
            return "\"\"";
        }
        StringBuilder formattedExpressionValue = new StringBuilder();
        if (expressionValue.contains(",")) {
            formattedExpressionValue.append("'");
            List<String> formattedValues = DmnJsonConverterUtil.split(expressionValue);
            formattedExpressionValue.append(StringUtils.join(formattedValues, (char)','));
        } else {
            String formattedValue = expressionValue;
            formattedExpressionValue.append(formattedValue);
        }
        if (expressionValue.contains(",")) {
            formattedExpressionValue.append("'");
        }
        return formattedExpressionValue.toString();
    }

    protected static List<String> split(String str) {
        String regex = str.contains("\"") ? ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)" : ",";
        return Stream.of(str.split(regex)).map(elem -> elem.trim()).collect(Collectors.toList());
    }

    protected static String transformCollectionOperation(String operatorValue, String inputType) {
        if (StringUtils.isEmpty((CharSequence)operatorValue) || StringUtils.isEmpty((CharSequence)inputType)) {
            throw new IllegalArgumentException("operator value and input type must be present");
        }
        if ("collection".equalsIgnoreCase(inputType)) {
            switch (operatorValue) {
                case "IN": {
                    return "ALL OF";
                }
                case "NOT IN": {
                    return "NONE OF";
                }
                case "ANY": {
                    return "ANY OF";
                }
                case "NOT ANY": {
                    return "NOT ALL OF";
                }
            }
            return operatorValue;
        }
        switch (operatorValue) {
            case "IN": {
                return "IS IN";
            }
            case "NOT IN": {
                return "IS NOT IN";
            }
            case "ANY": {
                return "IS IN";
            }
            case "NOT ANY": {
                return "IS NOT IN";
            }
        }
        return operatorValue;
    }

    public static class JsonLookupResult {
        private String id;
        private String name;
        private JsonNode jsonNode;

        public JsonLookupResult(String id, String name, JsonNode jsonNode) {
            this(name, jsonNode);
            this.id = id;
        }

        public JsonLookupResult(String name, JsonNode jsonNode) {
            this.name = name;
            this.jsonNode = jsonNode;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JsonNode getJsonNode() {
            return this.jsonNode;
        }

        public void setJsonNode(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }
    }
}

