/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.LiquibaseDatabaseConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LiquibaseBasedSchemaManager
implements SchemaManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String context;
    protected final String changeLogFile;
    protected final String changeLogPrefix;

    public LiquibaseBasedSchemaManager(String context, String changeLogFile, String changeLogPrefix) {
        this.context = context;
        this.changeLogFile = changeLogFile;
        this.changeLogPrefix = changeLogPrefix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initSchema(String databaseSchemaUpdate) {
        try {
            if ("create-drop".equals(databaseSchemaUpdate)) {
                this.schemaCreate();
                return;
            }
            if ("drop-create".equals(databaseSchemaUpdate)) {
                this.schemaDrop();
                this.schemaCreate();
                return;
            }
            if ("true".equals(databaseSchemaUpdate)) {
                this.schemaUpdate();
                return;
            }
            if (!"false".equals(databaseSchemaUpdate)) return;
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising " + this.context + " data model", (Throwable)e);
        }
    }

    @Override
    public void schemaCreate() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(this.getDatabaseConfiguration());
            liquibase.update(this.context);
        }
        catch (Exception e) {
            throw new FlowableException("Error creating " + this.context + " engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    @Override
    public void schemaDrop() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(this.getDatabaseConfiguration());
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping " + this.context + " engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    @Override
    public String schemaUpdate() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(this.getDatabaseConfiguration());
            liquibase.update(this.context);
        }
        catch (Exception e) {
            throw new FlowableException("Error updating " + this.context + " engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
        return null;
    }

    @Override
    public void schemaCheckVersion() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(this.getDatabaseConfiguration());
            liquibase.validate();
        }
        catch (Exception e) {
            throw new FlowableException("Error validating " + this.context + " engine schema", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    protected abstract LiquibaseDatabaseConfiguration getDatabaseConfiguration();

    protected Liquibase createLiquibaseInstance(LiquibaseDatabaseConfiguration databaseConfiguration) throws SQLException {
        Connection jdbcConnection = null;
        boolean closeConnection = false;
        try {
            String databaseCatalog;
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                jdbcConnection = databaseConfiguration.getDataSource().getConnection();
                closeConnection = true;
            } else {
                jdbcConnection = commandContext.getSession(DbSqlSession.class).getSqlSession().getConnection();
            }
            if (!jdbcConnection.getAutoCommit()) {
                jdbcConnection.commit();
            }
            JdbcConnection connection = new JdbcConnection(jdbcConnection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(this.changeLogPrefix + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(this.changeLogPrefix + database.getDatabaseChangeLogLockTableName());
            String databaseSchema = databaseConfiguration.getDatabaseSchema();
            if (StringUtils.isNotEmpty((CharSequence)databaseSchema)) {
                database.setDefaultSchemaName(databaseSchema);
                database.setLiquibaseSchemaName(databaseSchema);
            }
            if (StringUtils.isNotEmpty((CharSequence)(databaseCatalog = databaseConfiguration.getDatabaseCatalog()))) {
                database.setDefaultCatalogName(databaseCatalog);
                database.setLiquibaseCatalogName(databaseCatalog);
            }
            return new Liquibase(this.changeLogFile, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        }
        catch (Exception e) {
            if (jdbcConnection != null && closeConnection) {
                jdbcConnection.close();
            }
            throw new FlowableException("Error creating " + this.context + " liquibase instance", (Throwable)e);
        }
    }

    protected void closeDatabase(Liquibase liquibase) {
        Database database;
        if (liquibase != null && (database = liquibase.getDatabase()) != null && Context.getCommandContext() == null) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                this.logger.warn("Error closing database for {}", (Object)this.context, (Object)e);
            }
        }
    }
}

