/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.runtime.ClockReader;

public abstract class BusinessCalendarImpl
implements BusinessCalendar {
    protected ClockReader clockReader;
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy-MM");

    public BusinessCalendarImpl(ClockReader clockReader) {
        this.clockReader = clockReader;
    }

    @Override
    public Date resolveDuedate(String duedateDescription) {
        return this.resolveDuedate(duedateDescription, -1);
    }

    @Override
    public abstract Date resolveDuedate(String var1, int var2);

    @Override
    public Boolean validateDuedate(String duedateDescription, int maxIterations, Date endDate, Date newTimer) {
        return endDate == null || endDate.after(newTimer) || endDate.equals(newTimer);
    }

    @Override
    public Date resolveEndDate(String endDateString) {
        Date parse = null;
        try {
            parse = BusinessCalendarImpl.parse(endDateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parse;
    }

    public static Date parse(String source) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        if (source.length() <= dateTimeFormat.toPattern().length() && source.length() >= dateTimeFormat.toPattern().length() - 5) {
            try {
                return dateTimeFormat.parse(source);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (source.length() <= dateFormat.toPattern().length() && source.length() >= dateFormat.toPattern().length() - 2) {
            try {
                return dateFormat.parse(source);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (source.length() <= monthFormat.toPattern().length() && source.length() >= monthFormat.toPattern().length() - 1) {
            try {
                return monthFormat.parse(source);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return dateTimeFormat.parse(source);
    }
}

