/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence.cache;

import cn.hutool.core.util.ObjUtil;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.entity.Entity;

public class CachedEntity {
    protected Entity entity;
    protected Object originalPersistentState;

    public CachedEntity(Entity entity, boolean storeState) {
        this.entity = entity;
        if (storeState) {
            this.originalPersistentState = entity.getPersistentState();
            entity.setOriginalPersistentState(this.originalPersistentState);
        } else if (entity.getOriginalPersistentState() == null) {
            entity.setOriginalPersistentState(new HashMap(1));
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Object getOriginalPersistentState() {
        return this.originalPersistentState;
    }

    public void setOriginalPersistentState(Object originalPersistentState) {
        this.originalPersistentState = originalPersistentState;
    }

    public boolean hasChanged() {
        return this.entity.getPersistentState() != null && !this.entity.getPersistentState().equals(this.originalPersistentState) && this.notEqualsValue((Map)this.entity.getPersistentState(), (Map)this.originalPersistentState);
    }

    private boolean notEqualsValue(Map<String, Object> persistentState, Map<String, Object> originalPersistentState) {
        if (originalPersistentState == null) {
            return true;
        }
        if (persistentState.size() != originalPersistentState.size()) {
            return true;
        }
        for (Map.Entry<String, Object> entry : persistentState.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (ObjUtil.equals((Object)value, (Object)originalPersistentState.get(key))) continue;
            return true;
        }
        return false;
    }
}

