/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class SaveCommentCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected CommentEntity comment;

    public SaveCommentCmd(CommentEntity comment) {
        this.comment = comment;
    }

    public Void execute(CommandContext commandContext) {
        if (this.comment == null) {
            throw new FlowableIllegalArgumentException("comment is null");
        }
        if (this.comment.getId() == null) {
            throw new FlowableIllegalArgumentException("comment id is null");
        }
        CommentEntityManager commentEntityManager = CommandContextUtil.getCommentEntityManager(commandContext);
        Object eventMessage = this.comment.getFullMessage().replaceAll("\\s+", " ");
        if (((String)eventMessage).length() > 163) {
            eventMessage = ((String)eventMessage).substring(0, 160) + "...";
        }
        this.comment.setMessage((String)eventMessage);
        commentEntityManager.update(this.comment);
        return null;
    }
}

