/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.flowable.eventregistry.api.CorrelationKeyGenerator;

public class DefaultCorrelationKeyGenerator
implements CorrelationKeyGenerator<Map<String, Object>> {
    public String generateKey(Map<String, Object> source) {
        MessageDigest digest;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(source.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Object sourceValue = source.get(key);
            String value = sourceValue == null ? "" : sourceValue.toString();
            sb.append(key).append("=").append(value).append(";");
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available. Fatal (should be in the JDK).");
        }
        byte[] bytes = digest.digest(sb.toString().getBytes(StandardCharsets.UTF_8));
        return String.format("%x", new BigInteger(1, bytes));
    }
}

