/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.db.HasRevision;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.EntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.idm.api.event.FlowableIdmEventType;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.delegate.event.impl.FlowableIdmEventBuilder;
import org.flowable.idm.engine.impl.persistence.AbstractManager;

public abstract class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public AbstractEntityManager(IdmEngineConfiguration idmEngineConfiguration) {
        super(idmEngineConfiguration);
    }

    public EntityImpl findById(String entityId) {
        return (EntityImpl)this.getDataManager().findById(entityId);
    }

    public EntityImpl create() {
        return (EntityImpl)this.getDataManager().create();
    }

    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        if (entity instanceof HasRevision) {
            ((HasRevision)entity).setRevision(((HasRevision)entity).getRevisionNext());
        }
        this.getDataManager().insert(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createEntityEvent(FlowableIdmEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createEntityEvent(FlowableIdmEventType.ENTITY_INITIALIZED, entity));
        }
    }

    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        Entity updatedEntity = this.getDataManager().update(entity);
        if (fireUpdateEvent && this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createEntityEvent(FlowableIdmEventType.ENTITY_UPDATED, entity));
        }
        return (EntityImpl)updatedEntity;
    }

    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDataManager().delete(entity);
        if (fireDeleteEvent && this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createEntityEvent(FlowableIdmEventType.ENTITY_DELETED, entity));
        }
    }

    protected abstract DataManager<EntityImpl> getDataManager();
}

