/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.data.DeadLetterJobDataManager;

public class DeadLetterJobEntityManagerImpl
extends AbstractEntityManager<DeadLetterJobEntity>
implements DeadLetterJobEntityManager {
    protected DeadLetterJobDataManager jobDataManager;

    public DeadLetterJobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, DeadLetterJobDataManager jobDataManager) {
        super(jobServiceConfiguration);
        this.jobDataManager = jobDataManager;
    }

    @Override
    public List<DeadLetterJobEntity> findJobsByExecutionId(String id) {
        return this.jobDataManager.findJobsByExecutionId(id);
    }

    @Override
    public List<DeadLetterJobEntity> findJobsByProcessInstanceId(String id) {
        return this.jobDataManager.findJobsByProcessInstanceId(id);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(DeadLetterJobQueryImpl jobQuery) {
        return this.jobDataManager.findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(DeadLetterJobQueryImpl jobQuery) {
        return this.jobDataManager.findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.jobDataManager.updateJobTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void insert(DeadLetterJobEntity jobEntity, boolean fireCreateEvent) {
        if (this.getJobServiceConfiguration().getInternalJobManager() != null) {
            this.getJobServiceConfiguration().getInternalJobManager().handleJobInsert(jobEntity);
        }
        jobEntity.setCreateTime(this.getJobServiceConfiguration().getClock().getCurrentTime());
        super.insert(jobEntity, fireCreateEvent);
    }

    @Override
    public void insert(DeadLetterJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    @Override
    public void delete(DeadLetterJobEntity jobEntity) {
        super.delete(jobEntity);
        this.deleteByteArrayRef(jobEntity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getCustomValuesByteArrayRef());
        if (this.getJobServiceConfiguration().getInternalJobManager() != null) {
            this.getJobServiceConfiguration().getInternalJobManager().handleJobDelete(jobEntity);
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
    }

    protected DeadLetterJobEntity createDeadLetterJob(AbstractRuntimeJobEntity job) {
        DeadLetterJobEntity newJobEntity = (DeadLetterJobEntity)this.create();
        newJobEntity.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        newJobEntity.setCustomValues(job.getCustomValues());
        newJobEntity.setJobHandlerType(job.getJobHandlerType());
        newJobEntity.setExclusive(job.isExclusive());
        newJobEntity.setRepeat(job.getRepeat());
        newJobEntity.setRetries(job.getRetries());
        newJobEntity.setEndDate(job.getEndDate());
        newJobEntity.setExecutionId(job.getExecutionId());
        newJobEntity.setProcessInstanceId(job.getProcessInstanceId());
        newJobEntity.setProcessDefinitionId(job.getProcessDefinitionId());
        newJobEntity.setScopeId(job.getScopeId());
        newJobEntity.setSubScopeId(job.getSubScopeId());
        newJobEntity.setScopeType(job.getScopeType());
        newJobEntity.setScopeDefinitionId(job.getScopeDefinitionId());
        newJobEntity.setTenantId(job.getTenantId());
        newJobEntity.setJobType(job.getJobType());
        return newJobEntity;
    }

    protected DeadLetterJobDataManager getDataManager() {
        return this.jobDataManager;
    }

    public void setJobDataManager(DeadLetterJobDataManager jobDataManager) {
        this.jobDataManager = jobDataManager;
    }
}

