/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistoryListener;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class AsyncHistorySessionCommandContextCloseListener
implements CommandContextCloseListener {
    protected AsyncHistorySession asyncHistorySession;
    protected AsyncHistoryListener asyncHistoryListener;
    protected String typeFieldName = "type";
    protected String dataFieldName = "data";

    public AsyncHistorySessionCommandContextCloseListener() {
    }

    public AsyncHistorySessionCommandContextCloseListener(AsyncHistorySession asyncHistorySession, AsyncHistoryListener asyncHistoryListener) {
        this.asyncHistorySession = asyncHistorySession;
        this.asyncHistoryListener = asyncHistoryListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closing(CommandContext commandContext) {
        Map<JobServiceConfiguration, AsyncHistorySession.AsyncHistorySessionData> sessionData = this.asyncHistorySession.getSessionData();
        for (JobServiceConfiguration jobServiceConfiguration : sessionData.keySet()) {
            Map<String, List<ObjectNode>> jobData = sessionData.get((Object)jobServiceConfiguration).getJobData();
            if (jobData.isEmpty()) continue;
            ArrayList<ObjectNode> objectNodes = new ArrayList<ObjectNode>();
            for (String type : this.asyncHistorySession.getJobDataTypes()) {
                if (!jobData.containsKey(type)) continue;
                this.generateJson(jobServiceConfiguration, jobData, objectNodes, type);
                jobData.remove(type);
            }
            if (!jobData.isEmpty()) {
                for (String type : jobData.keySet()) {
                    this.generateJson(jobServiceConfiguration, jobData, objectNodes, type);
                }
            }
            JobServiceConfiguration originalJobServiceConfiguration = CommandContextUtil.getJobServiceConfiguration(commandContext);
            try {
                commandContext.getCurrentEngineConfiguration().getServiceConfigurations().put("cfg.jobService", jobServiceConfiguration);
                this.asyncHistoryListener.historyDataGenerated(jobServiceConfiguration, objectNodes);
            }
            finally {
                commandContext.getCurrentEngineConfiguration().getServiceConfigurations().put("cfg.jobService", originalJobServiceConfiguration);
            }
        }
    }

    protected void generateJson(JobServiceConfiguration jobServiceConfiguration, Map<String, List<ObjectNode>> jobData, List<ObjectNode> objectNodes, String type) {
        List<ObjectNode> historicDataList = jobData.get(type);
        for (ObjectNode historicData : historicDataList) {
            ObjectNode historyJson = this.generateJson(jobServiceConfiguration, type, historicData);
            objectNodes.add(historyJson);
        }
    }

    protected ObjectNode generateJson(JobServiceConfiguration jobServiceConfiguration, String type, ObjectNode historicData) {
        ObjectNode elementObjectNode = jobServiceConfiguration.getObjectMapper().createObjectNode();
        elementObjectNode.put(this.typeFieldName, type);
        elementObjectNode.set(this.dataFieldName, (JsonNode)historicData);
        return elementObjectNode;
    }

    public void closed(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public AsyncHistorySession getAsyncHistorySession() {
        return this.asyncHistorySession;
    }

    public void setAsyncHistorySession(AsyncHistorySession asyncHistorySession) {
        this.asyncHistorySession = asyncHistorySession;
    }

    public AsyncHistoryListener getAsyncHistoryListener() {
        return this.asyncHistoryListener;
    }

    public void setAsyncHistoryListener(AsyncHistoryListener asyncHistoryListener) {
        this.asyncHistoryListener = asyncHistoryListener;
    }

    public String getTypeFieldName() {
        return this.typeFieldName;
    }

    public void setTypeFieldName(String typeFieldName) {
        this.typeFieldName = typeFieldName;
    }

    public String getDataFieldName() {
        return this.dataFieldName;
    }

    public void setDataFieldName(String dataFieldName) {
        this.dataFieldName = dataFieldName;
    }
}

