/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionState;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.HistoryJobHandler;
import org.flowable.job.service.HistoryJobProcessor;
import org.flowable.job.service.HistoryJobProcessorContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobProcessor;
import org.flowable.job.service.JobProcessorContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.HistoryJobProcessorContextImpl;
import org.flowable.job.service.impl.JobProcessorContextImpl;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncJobAddedNotification;
import org.flowable.job.service.impl.asyncexecutor.JobAddedTransactionListener;
import org.flowable.job.service.impl.asyncexecutor.JobManager;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.history.async.TriggerAsyncHistoryExecutorTransactionListener;
import org.flowable.job.service.impl.persistence.entity.AbstractJobEntity;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobByteArrayRef;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.service.impl.el.NoExecutionVariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobManager
implements JobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJobManager.class);
    public static final String CYCLE_TYPE = "cycle";
    protected JobServiceConfiguration jobServiceConfiguration;

    public DefaultJobManager() {
    }

    public DefaultJobManager(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    @Override
    public void createAsyncJob(JobEntity jobEntity, boolean exclusive) {
        if (this.isAsyncExecutorActive()) {
            this.internalCreateLockedAsyncJob(jobEntity, exclusive);
        } else {
            this.internalCreateAsyncJob(jobEntity, exclusive);
        }
    }

    @Override
    public void scheduleAsyncJob(JobEntity jobEntity) {
        this.callJobProcessors(JobProcessorContext.Phase.BEFORE_CREATE, jobEntity);
        this.jobServiceConfiguration.getJobEntityManager().insert(jobEntity);
        this.triggerExecutorIfNeeded(jobEntity);
    }

    protected void triggerExecutorIfNeeded(JobEntity jobEntity) {
        if (this.isAsyncExecutorActive()) {
            this.hintAsyncExecutor(jobEntity);
        }
    }

    @Override
    public void scheduleTimerJob(TimerJobEntity timerJob) {
        this.scheduleTimer(timerJob);
        this.sendTimerScheduledEvent(timerJob);
    }

    private void scheduleTimer(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new FlowableException("Empty timer job can not be scheduled");
        }
        this.callJobProcessors(JobProcessorContext.Phase.BEFORE_CREATE, timerJob);
        this.jobServiceConfiguration.getTimerJobEntityManager().insert(timerJob);
    }

    private void sendTimerScheduledEvent(TimerJobEntity timerJob) {
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.TIMER_SCHEDULED, timerJob));
        }
    }

    @Override
    public JobEntity moveTimerJobToExecutableJob(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new FlowableException("Empty timer job can not be scheduled");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(timerJob);
        boolean insertSuccessful = this.jobServiceConfiguration.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccessful) {
            this.jobServiceConfiguration.getTimerJobEntityManager().delete(timerJob);
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public TimerJobEntity moveJobToTimerJob(AbstractRuntimeJobEntity job) {
        TimerJobEntity timerJob = this.createTimerJobFromOtherJob(job);
        boolean insertSuccessful = this.jobServiceConfiguration.getTimerJobEntityManager().insertTimerJobEntity(timerJob);
        if (insertSuccessful) {
            if (job instanceof JobEntity) {
                this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
            } else if (job instanceof SuspendedJobEntity) {
                this.jobServiceConfiguration.getSuspendedJobEntityManager().delete((SuspendedJobEntity)job);
            }
            return timerJob;
        }
        return null;
    }

    @Override
    public SuspendedJobEntity moveJobToSuspendedJob(AbstractRuntimeJobEntity job) {
        SuspendedJobEntity suspendedJob = this.createSuspendedJobFromOtherJob(job);
        this.jobServiceConfiguration.getSuspendedJobEntityManager().insert(suspendedJob);
        if (job instanceof TimerJobEntity) {
            this.jobServiceConfiguration.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
        }
        return suspendedJob;
    }

    @Override
    public AbstractRuntimeJobEntity activateSuspendedJob(SuspendedJobEntity job) {
        AbstractRuntimeJobEntity activatedJob = null;
        if ("timer".equals(job.getJobType())) {
            activatedJob = this.createTimerJobFromOtherJob(job);
            this.jobServiceConfiguration.getTimerJobEntityManager().insert(activatedJob);
        } else {
            activatedJob = this.createExecutableJobFromOtherJob(job);
            JobEntity jobEntity = (JobEntity)activatedJob;
            this.jobServiceConfiguration.getJobEntityManager().insert(jobEntity);
            this.triggerExecutorIfNeeded(jobEntity);
        }
        this.jobServiceConfiguration.getSuspendedJobEntityManager().delete(job);
        return activatedJob;
    }

    @Override
    public DeadLetterJobEntity moveJobToDeadLetterJob(AbstractRuntimeJobEntity job) {
        DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(job);
        this.jobServiceConfiguration.getDeadLetterJobEntityManager().insert(deadLetterJob);
        if (job instanceof TimerJobEntity) {
            this.jobServiceConfiguration.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
        }
        return deadLetterJob;
    }

    @Override
    public JobEntity moveDeadLetterJobToExecutableJob(DeadLetterJobEntity deadLetterJobEntity, int retries) {
        if (deadLetterJobEntity == null) {
            throw new FlowableIllegalArgumentException("Null job provided");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(deadLetterJobEntity);
        executableJob.setRetries(retries);
        boolean insertSuccessful = this.jobServiceConfiguration.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccessful) {
            this.jobServiceConfiguration.getDeadLetterJobEntityManager().delete(deadLetterJobEntity);
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public void execute(JobInfo job) {
        if (job instanceof HistoryJobEntity) {
            this.callHistoryJobProcessors(HistoryJobProcessorContext.Phase.BEFORE_EXECUTE, (HistoryJobEntity)job);
            this.executeHistoryJob((HistoryJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.callJobProcessors(JobProcessorContext.Phase.BEFORE_EXECUTE, (JobEntity)job);
            if ("message".equals(((Job)job).getJobType())) {
                this.executeMessageJob((JobEntity)job);
            } else if ("timer".equals(((Job)job).getJobType())) {
                this.executeTimerJob((JobEntity)job);
            }
        } else {
            throw new FlowableException("Only jobs with type JobEntity are supported to be executed");
        }
    }

    @Override
    public void unacquire(JobInfo job) {
        if (job instanceof HistoryJob) {
            HistoryJobEntity jobEntity = (HistoryJobEntity)job;
            HistoryJobEntity newJobEntity = (HistoryJobEntity)this.jobServiceConfiguration.getHistoryJobEntityManager().create();
            this.copyHistoryJobInfo(newJobEntity, jobEntity);
            newJobEntity.setId(null);
            newJobEntity.setLockExpirationTime(null);
            newJobEntity.setLockOwner(null);
            this.jobServiceConfiguration.getHistoryJobEntityManager().insert(newJobEntity);
            this.jobServiceConfiguration.getHistoryJobEntityManager().deleteNoCascade(jobEntity);
        } else if (job instanceof JobEntity) {
            JobEntity jobEntity = (JobEntity)job;
            JobEntity newJobEntity = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().create();
            this.copyJobInfo(newJobEntity, jobEntity);
            newJobEntity.setId(null);
            newJobEntity.setLockExpirationTime(null);
            newJobEntity.setLockOwner(null);
            this.jobServiceConfiguration.getJobEntityManager().insert(newJobEntity);
            this.jobServiceConfiguration.getJobEntityManager().delete(jobEntity.getId());
        } else if (job != null) {
            this.jobServiceConfiguration.getJobEntityManager().resetExpiredJob(job.getId());
        } else {
            throw new FlowableException("Programmatic error: null job passed");
        }
    }

    @Override
    public void unacquireWithDecrementRetries(JobInfo job) {
        if (job instanceof HistoryJob) {
            HistoryJobEntity historyJobEntity = (HistoryJobEntity)job;
            if (historyJobEntity.getRetries() > 0) {
                HistoryJobEntity newHistoryJobEntity = (HistoryJobEntity)this.jobServiceConfiguration.getHistoryJobEntityManager().create();
                this.copyHistoryJobInfo(newHistoryJobEntity, historyJobEntity);
                newHistoryJobEntity.setId(null);
                newHistoryJobEntity.setLockExpirationTime(null);
                newHistoryJobEntity.setLockOwner(null);
                newHistoryJobEntity.setCreateTime(this.jobServiceConfiguration.getClock().getCurrentTime());
                newHistoryJobEntity.setRetries(newHistoryJobEntity.getRetries() - 1);
                this.jobServiceConfiguration.getHistoryJobEntityManager().insert(newHistoryJobEntity);
                this.jobServiceConfiguration.getHistoryJobEntityManager().deleteNoCascade(historyJobEntity);
            } else {
                this.jobServiceConfiguration.getHistoryJobEntityManager().delete(historyJobEntity);
            }
        } else {
            JobEntity jobEntity = (JobEntity)job;
            JobEntity newJobEntity = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().create();
            this.copyJobInfo(newJobEntity, jobEntity);
            newJobEntity.setId(null);
            newJobEntity.setLockExpirationTime(null);
            newJobEntity.setLockOwner(null);
            if (newJobEntity.getRetries() > 0) {
                newJobEntity.setRetries(newJobEntity.getRetries() - 1);
                this.jobServiceConfiguration.getJobEntityManager().insert(newJobEntity);
            } else {
                DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(newJobEntity);
                this.jobServiceConfiguration.getDeadLetterJobEntityManager().insert(deadLetterJob);
            }
            this.jobServiceConfiguration.getJobEntityManager().delete(jobEntity.getId());
        }
    }

    protected void executeMessageJob(JobEntity jobEntity) {
        this.executeJobHandler(jobEntity);
        if (jobEntity.getId() != null) {
            CommandContextUtil.getJobEntityManager().delete(jobEntity);
        }
    }

    protected void executeHistoryJob(HistoryJobEntity historyJobEntity) {
        this.executeHistoryJobHandler(historyJobEntity);
        if (historyJobEntity.getId() != null) {
            CommandContextUtil.getHistoryJobEntityManager().delete(historyJobEntity);
        }
    }

    protected void executeTimerJob(JobEntity timerEntity) {
        TimerJobEntity newTimerJobEntity;
        TimerJobEntityManager timerJobEntityManager = this.jobServiceConfiguration.getTimerJobEntityManager();
        NoExecutionVariableScope variableScope = null;
        if (this.jobServiceConfiguration.getInternalJobManager() != null) {
            variableScope = this.jobServiceConfiguration.getInternalJobManager().resolveVariableScope(timerEntity);
        }
        if (variableScope == null) {
            variableScope = NoExecutionVariableScope.getSharedInstance();
        }
        if (this.jobServiceConfiguration.getInternalJobManager() != null) {
            this.jobServiceConfiguration.getInternalJobManager().preTimerJobDelete(timerEntity, (VariableScope)variableScope);
        }
        if (timerEntity.getDuedate() != null && !this.isValidTime(timerEntity, timerEntity.getDuedate(), (VariableScope)variableScope)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Timer {} fired. but the dueDate is after the endDate.  Deleting timer.", (Object)timerEntity.getId());
            }
            this.jobServiceConfiguration.getJobEntityManager().delete(timerEntity);
            return;
        }
        this.executeJobHandler(timerEntity);
        this.jobServiceConfiguration.getJobEntityManager().delete(timerEntity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Timer {} fired. Deleting timer.", (Object)timerEntity.getId());
        }
        if (timerEntity.getRepeat() != null && (newTimerJobEntity = timerJobEntityManager.createAndCalculateNextTimer(timerEntity, (VariableScope)variableScope)) != null) {
            if (this.jobServiceConfiguration.getInternalJobManager() != null) {
                this.jobServiceConfiguration.getInternalJobManager().preRepeatedTimerSchedule(newTimerJobEntity, (VariableScope)variableScope);
            }
            this.scheduleTimerJob(newTimerJobEntity);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeJobHandler(JobEntity jobEntity) {
        NoExecutionVariableScope variableScope = null;
        if (this.jobServiceConfiguration.getInternalJobManager() != null) {
            variableScope = this.jobServiceConfiguration.getInternalJobManager().resolveVariableScope(jobEntity);
        }
        if (variableScope == null) {
            variableScope = NoExecutionVariableScope.getSharedInstance();
        }
        Map<String, JobHandler> jobHandlers = this.jobServiceConfiguration.getJobHandlers();
        if (jobEntity.getJobHandlerType() == null) throw new FlowableException("Job has no job handler type in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        if (jobHandlers == null) throw new FlowableException("No job handler registered for type " + jobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        JobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        if (jobHandler == null) {
            throw new FlowableException("No job handler registered for type " + jobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        }
        jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), (VariableScope)variableScope, this.getCommandContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeHistoryJobHandler(HistoryJobEntity historyJobEntity) {
        Map<String, HistoryJobHandler> jobHandlers = this.jobServiceConfiguration.getHistoryJobHandlers();
        if (historyJobEntity.getJobHandlerType() == null) throw new FlowableException("Async history job has no job handler type in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        if (jobHandlers == null) throw new FlowableException("No history job handler registered for type " + historyJobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        HistoryJobHandler jobHandler = jobHandlers.get(historyJobEntity.getJobHandlerType());
        if (jobHandler == null) {
            throw new FlowableException("No history job handler registered for type " + historyJobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        }
        jobHandler.execute(historyJobEntity, historyJobEntity.getJobHandlerConfiguration(), this.getCommandContext());
    }

    protected boolean isValidTime(JobEntity timerEntity, Date newTimerDate, VariableScope variableScope) {
        BusinessCalendar businessCalendar = this.jobServiceConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(timerEntity, variableScope));
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected void hintAsyncExecutor(JobEntity job) {
        if (job.getLockOwner() == null || job.getLockExpirationTime() == null) {
            this.createAsyncJob(job, job.isExclusive());
        }
        this.createHintListeners(this.getAsyncExecutor(), job);
    }

    protected void createHintListeners(AsyncExecutor asyncExecutor, JobInfoEntity job) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (Context.getTransactionContext() != null) {
            JobAddedTransactionListener jobAddedTransactionListener = new JobAddedTransactionListener(job, asyncExecutor, CommandContextUtil.getJobServiceConfiguration(commandContext).getCommandExecutor());
            Context.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, (TransactionListener)jobAddedTransactionListener);
        } else {
            AsyncJobAddedNotification jobAddedNotification = new AsyncJobAddedNotification(job, asyncExecutor);
            commandContext.addCloseListener((CommandContextCloseListener)jobAddedNotification);
        }
    }

    @Override
    public String getBusinessCalendarName(JobEntity timerEntity, VariableScope variableScope) {
        String calendarValue = null;
        if (StringUtils.isNotEmpty((CharSequence)timerEntity.getJobHandlerConfiguration())) {
            try {
                JsonNode jobConfigNode = this.jobServiceConfiguration.getObjectMapper().readTree(timerEntity.getJobHandlerConfiguration());
                JsonNode calendarNameNode = jobConfigNode.get("calendarName");
                if (calendarNameNode != null && !calendarNameNode.isNull()) {
                    calendarValue = calendarNameNode.asText();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getBusinessCalendarName(calendarValue, variableScope);
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CYCLE_TYPE;
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            businessCalendarName = (String)CommandContextUtil.getJobServiceConfiguration().getExpressionManager().createExpression(calendarName).getValue((VariableContainer)variableScope);
        }
        return businessCalendarName;
    }

    @Override
    public HistoryJobEntity scheduleHistoryJob(HistoryJobEntity historyJobEntity) {
        this.callHistoryJobProcessors(HistoryJobProcessorContext.Phase.BEFORE_CREATE, historyJobEntity);
        this.jobServiceConfiguration.getHistoryJobEntityManager().insert(historyJobEntity);
        this.triggerAsyncHistoryExecutorIfNeeded(historyJobEntity);
        return historyJobEntity;
    }

    protected void triggerAsyncHistoryExecutorIfNeeded(HistoryJobEntity historyJobEntity) {
        if (this.isAsyncHistoryExecutorActive()) {
            this.hintAsyncHistoryExecutor(historyJobEntity);
        }
    }

    protected void hintAsyncHistoryExecutor(HistoryJobEntity historyJobEntity) {
        if (historyJobEntity.getLockOwner() == null || historyJobEntity.getLockExpirationTime() == null) {
            this.setLockTimeAndOwner(this.getAsyncHistoryExecutor(), historyJobEntity);
        }
        this.createAsyncHistoryHintListeners(historyJobEntity);
    }

    protected void createAsyncHistoryHintListeners(HistoryJobEntity historyJobEntity) {
        TransactionContext transactionContext;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        AsyncHistorySession asyncHistorySession = (AsyncHistorySession)commandContext.getSession(AsyncHistorySession.class);
        if (asyncHistorySession != null && (transactionContext = asyncHistorySession.getTransactionContext()) != null) {
            transactionContext.addTransactionListener(TransactionState.COMMITTED, (TransactionListener)new TriggerAsyncHistoryExecutorTransactionListener(commandContext, historyJobEntity));
        }
    }

    protected void internalCreateAsyncJob(JobEntity jobEntity, boolean exclusive) {
        this.fillDefaultAsyncJobInfo(jobEntity, exclusive);
    }

    protected void internalCreateLockedAsyncJob(JobEntity jobEntity, boolean exclusive) {
        this.fillDefaultAsyncJobInfo(jobEntity, exclusive);
        this.setLockTimeAndOwner(this.getAsyncExecutor(), jobEntity);
    }

    protected void setLockTimeAndOwner(AsyncExecutor asyncExecutor, JobInfoEntity jobInfoEntity) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, asyncExecutor.getAsyncJobLockTimeInMillis());
        jobInfoEntity.setLockExpirationTime(gregorianCalendar.getTime());
        jobInfoEntity.setLockOwner(asyncExecutor.getLockOwner());
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, boolean exclusive) {
        jobEntity.setJobType("message");
        jobEntity.setRevision(1);
        jobEntity.setRetries(this.jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExclusive(exclusive);
    }

    @Override
    public JobEntity createExecutableJobFromOtherJob(AbstractRuntimeJobEntity job) {
        JobEntity executableJob = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().create();
        this.copyJobInfo(executableJob, job);
        if (this.isAsyncExecutorActive()) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.jobServiceConfiguration.getClock().getCurrentTime());
            gregorianCalendar.add(14, this.getAsyncExecutor().getTimerLockTimeInMillis());
            executableJob.setLockExpirationTime(gregorianCalendar.getTime());
            executableJob.setLockOwner(this.getAsyncExecutor().getLockOwner());
        }
        return executableJob;
    }

    @Override
    public TimerJobEntity createTimerJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        TimerJobEntity timerJob = (TimerJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().create();
        this.copyJobInfo(timerJob, otherJob);
        return timerJob;
    }

    @Override
    public SuspendedJobEntity createSuspendedJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        SuspendedJobEntity suspendedJob = (SuspendedJobEntity)this.jobServiceConfiguration.getSuspendedJobEntityManager().create();
        this.copyJobInfo(suspendedJob, otherJob);
        return suspendedJob;
    }

    @Override
    public DeadLetterJobEntity createDeadLetterJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)this.jobServiceConfiguration.getDeadLetterJobEntityManager().create();
        this.copyJobInfo(deadLetterJob, otherJob);
        return deadLetterJob;
    }

    @Override
    public AbstractRuntimeJobEntity copyJobInfo(AbstractRuntimeJobEntity copyToJob, AbstractRuntimeJobEntity copyFromJob) {
        copyToJob.setDuedate(copyFromJob.getDuedate());
        copyToJob.setEndDate(copyFromJob.getEndDate());
        copyToJob.setExclusive(copyFromJob.isExclusive());
        copyToJob.setExecutionId(copyFromJob.getExecutionId());
        copyToJob.setId(copyFromJob.getId());
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        copyToJob.setCustomValues(copyFromJob.getCustomValues());
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setJobType(copyFromJob.getJobType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setExceptionStacktrace(copyFromJob.getExceptionStacktrace());
        copyToJob.setMaxIterations(copyFromJob.getMaxIterations());
        copyToJob.setProcessDefinitionId(copyFromJob.getProcessDefinitionId());
        copyToJob.setElementId(copyFromJob.getElementId());
        copyToJob.setElementName(copyFromJob.getElementName());
        copyToJob.setProcessInstanceId(copyFromJob.getProcessInstanceId());
        copyToJob.setScopeId(copyFromJob.getScopeId());
        copyToJob.setSubScopeId(copyFromJob.getSubScopeId());
        copyToJob.setScopeType(copyFromJob.getScopeType());
        copyToJob.setScopeDefinitionId(copyFromJob.getScopeDefinitionId());
        copyToJob.setRepeat(copyFromJob.getRepeat());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setRevision(copyFromJob.getRevision());
        copyToJob.setTenantId(copyFromJob.getTenantId());
        return copyToJob;
    }

    protected HistoryJobEntity copyHistoryJobInfo(HistoryJobEntity copyToJob, HistoryJobEntity copyFromJob) {
        copyToJob.setId(copyFromJob.getId());
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        if (copyFromJob.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            JobByteArrayRef configurationByteArrayRefCopy = copyFromJob.getAdvancedJobHandlerConfigurationByteArrayRef().copy();
            copyToJob.setAdvancedJobHandlerConfigurationByteArrayRef(configurationByteArrayRefCopy);
        }
        if (copyFromJob.getExceptionByteArrayRef() != null) {
            JobByteArrayRef exceptionByteArrayRefCopy = copyFromJob.getExceptionByteArrayRef();
            copyToJob.setExceptionByteArrayRef(exceptionByteArrayRefCopy);
        }
        if (copyFromJob.getCustomValuesByteArrayRef() != null) {
            JobByteArrayRef customValuesByteArrayRefCopy = copyFromJob.getCustomValuesByteArrayRef().copy();
            copyToJob.setCustomValuesByteArrayRef(customValuesByteArrayRefCopy);
        }
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setExceptionStacktrace(copyFromJob.getExceptionStacktrace());
        copyToJob.setCustomValues(copyFromJob.getCustomValues());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setRevision(copyFromJob.getRevision());
        copyToJob.setScopeType(copyFromJob.getScopeType());
        copyToJob.setTenantId(copyFromJob.getTenantId());
        return copyToJob;
    }

    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    @Override
    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    protected boolean isAsyncExecutorActive() {
        return this.isExecutorActive(this.jobServiceConfiguration.getAsyncExecutor());
    }

    protected boolean isAsyncHistoryExecutorActive() {
        return this.isExecutorActive(this.jobServiceConfiguration.getAsyncHistoryExecutor());
    }

    protected boolean isExecutorActive(AsyncExecutor asyncExecutor) {
        return asyncExecutor != null && asyncExecutor.isActive();
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected AsyncExecutor getAsyncExecutor() {
        return this.jobServiceConfiguration.getAsyncExecutor();
    }

    protected AsyncExecutor getAsyncHistoryExecutor() {
        return this.jobServiceConfiguration.getAsyncHistoryExecutor();
    }

    protected void callJobProcessors(JobProcessorContext.Phase processorType, AbstractJobEntity abstractJobEntity) {
        if (this.jobServiceConfiguration.getJobProcessors() != null) {
            JobProcessorContextImpl jobProcessorContext = new JobProcessorContextImpl(processorType, abstractJobEntity);
            for (JobProcessor jobProcessor : this.jobServiceConfiguration.getJobProcessors()) {
                jobProcessor.process(jobProcessorContext);
            }
        }
    }

    protected void callHistoryJobProcessors(HistoryJobProcessorContext.Phase processorType, HistoryJobEntity historyJobEntity) {
        if (this.jobServiceConfiguration.getHistoryJobProcessors() != null) {
            HistoryJobProcessorContextImpl historyJobProcessorContext = new HistoryJobProcessorContextImpl(processorType, historyJobEntity);
            for (HistoryJobProcessor historyJobProcessor : this.jobServiceConfiguration.getHistoryJobProcessors()) {
                historyJobProcessor.process(historyJobProcessorContext);
            }
        }
    }
}

