/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class BoundaryEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        BoundaryEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        BoundaryEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("BoundaryTimerEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryErrorEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundarySignalEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryMessageEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryCancelEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryCompensationEvent", BoundaryEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(BoundaryEvent.class, BoundaryEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)baseElement;
        List eventDefinitions = boundaryEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "BoundaryTimerEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "BoundaryErrorEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "BoundarySignalEvent";
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            return "BoundaryMessageEvent";
        }
        if (eventDefinition instanceof CancelEventDefinition) {
            return "BoundaryCancelEvent";
        }
        if (eventDefinition instanceof CompensateEventDefinition) {
            return "BoundaryCompensationEvent";
        }
        return "BoundaryTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)baseElement;
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(boundaryEvent.getId());
        GraphicInfo parentGraphicInfo = this.model.getGraphicInfo(boundaryEvent.getAttachedToRef().getId());
        dockNode.put("x", graphicInfo.getX() - parentGraphicInfo.getX());
        dockNode.put("y", graphicInfo.getY() - parentGraphicInfo.getY());
        dockersArrayNode.add((JsonNode)dockNode);
        this.flowElementNode.set("dockers", (JsonNode)dockersArrayNode);
        propertiesNode.put("cancelactivity", boundaryEvent.isCancelActivity());
        this.addEventProperties((Event)boundaryEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("BoundaryTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)boundaryEvent);
        } else if ("BoundarySignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryCancelEvent".equals(stencilId)) {
            CancelEventDefinition cancelEventDefinition = new CancelEventDefinition();
            boundaryEvent.getEventDefinitions().add(cancelEventDefinition);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryCompensationEvent".equals(stencilId)) {
            CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
            boundaryEvent.getEventDefinitions().add(compensateEventDefinition);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        }
        boundaryEvent.setAttachedToRefId(this.lookForAttachedRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes")));
        return boundaryEvent;
    }

    private String lookForAttachedRef(String boundaryEventId, JsonNode childShapesNode) {
        String attachedRefId = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !boundaryEventId.equals(resourceNode.asText())) continue;
                        attachedRefId = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (attachedRefId != null) break;
                }
                if ((attachedRefId = this.lookForAttachedRef(boundaryEventId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return attachedRefId;
    }
}

