/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.DataAssociation;
import org.flowable.bpmn.model.DataStoreReference;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.FormValue;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.MessageFlow;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.TerminateEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.constants.EditorJsonConstants;
import org.flowable.editor.constants.StencilConstants;
import org.flowable.editor.language.json.converter.ActivityProcessor;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBpmnJsonConverter
implements EditorJsonConstants,
StencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnJsonConverter.class);
    public static final String NAMESPACE = "http://flowable.org/modeler";
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected ActivityProcessor processor;
    protected BpmnModel model;
    protected ObjectNode flowElementNode;
    protected double subProcessX;
    protected double subProcessY;
    protected ArrayNode shapesArrayNode;

    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        ServiceTask serviceTask;
        this.model = model;
        this.processor = processor;
        this.subProcessX = subProcessX;
        this.subProcessY = subProcessY;
        this.shapesArrayNode = shapesArrayNode;
        GraphicInfo graphicInfo = model.getGraphicInfo(baseElement.getId());
        String stencilId = null;
        stencilId = baseElement instanceof ServiceTask ? ("mail".equalsIgnoreCase((serviceTask = (ServiceTask)baseElement).getType()) ? "MailTask" : ("camel".equalsIgnoreCase(serviceTask.getType()) ? "CamelTask" : ("mule".equalsIgnoreCase(serviceTask.getType()) ? "MuleTask" : ("http".equalsIgnoreCase(serviceTask.getType()) ? "HttpTask" : ("dmn".equalsIgnoreCase(serviceTask.getType()) ? "DecisionTask" : ("shell".equalsIgnoreCase(serviceTask.getType()) ? "ShellTask" : this.getStencilId(baseElement))))))) : this.getStencilId(baseElement);
        this.flowElementNode = BpmnJsonConverterUtil.createChildShape(baseElement.getId(), stencilId, graphicInfo.getX() - subProcessX + graphicInfo.getWidth(), graphicInfo.getY() - subProcessY + graphicInfo.getHeight(), graphicInfo.getX() - subProcessX, graphicInfo.getY() - subProcessY);
        shapesArrayNode.add((JsonNode)this.flowElementNode);
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", baseElement.getId());
        if (baseElement instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)baseElement;
            if (StringUtils.isNotEmpty((CharSequence)flowElement.getName())) {
                propertiesNode.put("name", flowElement.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)flowElement.getDocumentation())) {
                propertiesNode.put("documentation", flowElement.getDocumentation());
            }
        }
        this.convertElementToJson(propertiesNode, baseElement);
        this.flowElementNode.set("properties", (JsonNode)propertiesNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        if (baseElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)baseElement;
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getId()));
            }
            for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                if (!messageFlow.getSourceRef().equals(flowNode.getId())) continue;
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getId()));
            }
            for (Artifact artifact : model.getMainProcess().getArtifacts()) {
                Association association;
                if (!(artifact instanceof Association) || !(association = (Association)artifact).getSourceRef().equals(flowNode.getId())) continue;
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(artifact.getId()));
            }
        }
        if (baseElement instanceof Activity) {
            Object loopDef;
            Activity activity = (Activity)baseElement;
            for (BoundaryEvent boundaryEvent : activity.getBoundaryEvents()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(boundaryEvent.getId()));
            }
            propertiesNode.put("asynchronousdefinition", activity.isAsynchronous());
            propertiesNode.put("exclusivedefinition", !activity.isNotExclusive());
            propertiesNode.put("isforcompensation", activity.isForCompensation());
            if (activity.getLoopCharacteristics() != null && (StringUtils.isNotEmpty((CharSequence)(loopDef = activity.getLoopCharacteristics()).getLoopCardinality()) || StringUtils.isNotEmpty((CharSequence)loopDef.getInputDataItem()) || StringUtils.isNotEmpty((CharSequence)loopDef.getCompletionCondition()))) {
                if (!loopDef.isSequential()) {
                    propertiesNode.put("multiinstance_type", "Parallel");
                } else {
                    propertiesNode.put("multiinstance_type", "Sequential");
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getLoopCardinality())) {
                    propertiesNode.put("multiinstance_cardinality", loopDef.getLoopCardinality());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getInputDataItem())) {
                    propertiesNode.put("multiinstance_collection", loopDef.getInputDataItem());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getElementVariable())) {
                    propertiesNode.put("multiinstance_variable", loopDef.getElementVariable());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getCompletionCondition())) {
                    propertiesNode.put("multiinstance_condition", loopDef.getCompletionCondition());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getElementIndexVariable())) {
                    propertiesNode.put("multiinstance_index_variable", loopDef.getElementIndexVariable());
                }
            }
            if (activity instanceof UserTask) {
                BpmnJsonConverterUtil.convertListenersToJson(((UserTask)activity).getTaskListeners(), false, propertiesNode);
            }
            if (CollectionUtils.isNotEmpty(activity.getDataInputAssociations())) {
                for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                    if (model.getFlowElement(dataAssociation.getSourceRef()) == null) continue;
                    this.createDataAssociation(dataAssociation, true, activity);
                }
            }
            if (CollectionUtils.isNotEmpty(activity.getDataOutputAssociations())) {
                for (DataAssociation dataAssociation : activity.getDataOutputAssociations()) {
                    if (model.getFlowElement(dataAssociation.getTargetRef()) == null) continue;
                    this.createDataAssociation(dataAssociation, false, activity);
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(dataAssociation.getId()));
                }
            }
        }
        if (baseElement instanceof FlowElement) {
            BpmnJsonConverterUtil.convertListenersToJson(((FlowElement)baseElement).getExecutionListeners(), true, propertiesNode);
        }
        for (Artifact artifact : container.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || !StringUtils.isNotEmpty((CharSequence)(association = (Association)artifact).getSourceRef()) || !association.getSourceRef().equals(baseElement.getId())) continue;
            outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(association.getId()));
        }
        if (baseElement instanceof DataStoreReference) {
            for (Process process : model.getProcesses()) {
                this.processDataStoreReferences((FlowElementsContainer)process, baseElement.getId(), outgoingArrayNode);
            }
        }
        this.flowElementNode.set("outgoing", (JsonNode)outgoingArrayNode);
    }

    protected void processDataStoreReferences(FlowElementsContainer container, String dataStoreReferenceId, ArrayNode outgoingArrayNode) {
        for (FlowElement flowElement : container.getFlowElements()) {
            if (flowElement instanceof Activity) {
                Activity activity = (Activity)flowElement;
                if (!CollectionUtils.isNotEmpty(activity.getDataInputAssociations())) continue;
                for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                    if (!dataStoreReferenceId.equals(dataAssociation.getSourceRef())) continue;
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(dataAssociation.getId()));
                }
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            this.processDataStoreReferences((FlowElementsContainer)((SubProcess)flowElement), dataStoreReferenceId, outgoingArrayNode);
        }
    }

    protected void createDataAssociation(DataAssociation dataAssociation, boolean incoming, Activity activity) {
        String sourceRef = null;
        String targetRef = null;
        if (incoming) {
            sourceRef = dataAssociation.getSourceRef();
            targetRef = activity.getId();
        } else {
            sourceRef = activity.getId();
            targetRef = dataAssociation.getTargetRef();
        }
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(dataAssociation.getId(), "DataAssociation", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", this.model.getGraphicInfo(sourceRef).getWidth() / 2.0);
        dockNode.put("y", this.model.getGraphicInfo(sourceRef).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        if (this.model.getFlowLocationGraphicInfo(dataAssociation.getId()).size() > 2) {
            for (int i = 1; i < this.model.getFlowLocationGraphicInfo(dataAssociation.getId()).size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)this.model.getFlowLocationGraphicInfo(dataAssociation.getId()).get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", this.model.getGraphicInfo(targetRef).getWidth() / 2.0);
        dockNode.put("y", this.model.getGraphicInfo(targetRef).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.set("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(targetRef));
        flowNode.set("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.set("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(targetRef));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", dataAssociation.getId());
        flowNode.set("properties", (JsonNode)propertiesNode);
        this.shapesArrayNode.add((JsonNode)flowNode);
    }

    public void convertToBpmnModel(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, BpmnModel bpmnModel) {
        Lane lane;
        FlowElement flowElement;
        this.processor = processor;
        this.model = bpmnModel;
        BaseElement baseElement = this.convertJsonToElement(elementNode, modelNode, shapeMap);
        baseElement.setId(BpmnJsonConverterUtil.getElementId(elementNode));
        if (baseElement instanceof FlowElement) {
            flowElement = (FlowElement)baseElement;
            flowElement.setName(this.getPropertyValueAsString("name", elementNode));
            flowElement.setDocumentation(this.getPropertyValueAsString("documentation", elementNode));
            BpmnJsonConverterUtil.convertJsonToListeners(elementNode, (BaseElement)flowElement);
            if (baseElement instanceof Activity) {
                Activity activity = (Activity)baseElement;
                activity.setAsynchronous(this.getPropertyValueAsBoolean("asynchronousdefinition", elementNode));
                activity.setNotExclusive(!this.getPropertyValueAsBoolean("exclusivedefinition", elementNode));
                activity.setForCompensation(this.getPropertyValueAsBoolean("isforcompensation", elementNode));
                String multiInstanceType = this.getPropertyValueAsString("multiinstance_type", elementNode);
                String multiInstanceCardinality = this.getPropertyValueAsString("multiinstance_cardinality", elementNode);
                String multiInstanceCollection = this.getPropertyValueAsString("multiinstance_collection", elementNode);
                String multiInstanceCondition = this.getPropertyValueAsString("multiinstance_condition", elementNode);
                String multiInstanceIndexVariable = this.getPropertyValueAsString("multiinstance_index_variable", elementNode);
                if (StringUtils.isNotEmpty((CharSequence)multiInstanceType) && !"none".equalsIgnoreCase(multiInstanceType)) {
                    String multiInstanceVariable = this.getPropertyValueAsString("multiinstance_variable", elementNode);
                    MultiInstanceLoopCharacteristics multiInstanceObject = new MultiInstanceLoopCharacteristics();
                    if ("sequential".equalsIgnoreCase(multiInstanceType)) {
                        multiInstanceObject.setSequential(true);
                    } else {
                        multiInstanceObject.setSequential(false);
                    }
                    multiInstanceObject.setLoopCardinality(multiInstanceCardinality);
                    multiInstanceObject.setInputDataItem(multiInstanceCollection);
                    multiInstanceObject.setElementVariable(multiInstanceVariable);
                    multiInstanceObject.setCompletionCondition(multiInstanceCondition);
                    multiInstanceObject.setElementIndexVariable(multiInstanceIndexVariable);
                    activity.setLoopCharacteristics(multiInstanceObject);
                }
            } else if (baseElement instanceof Gateway) {
                JsonNode orderArray;
                Gateway gateway = (Gateway)baseElement;
                gateway.setAsynchronous(this.getPropertyValueAsBoolean("asynchronousdefinition", elementNode));
                gateway.setNotExclusive(!this.getPropertyValueAsBoolean("exclusivedefinition", elementNode));
                JsonNode flowOrderNode = this.getProperty("sequencefloworder", elementNode);
                if (flowOrderNode != null && (orderArray = (flowOrderNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(flowOrderNode)).get("sequenceFlowOrder")) != null && orderArray.size() > 0) {
                    for (JsonNode orderNode : orderArray) {
                        ExtensionElement orderElement = new ExtensionElement();
                        orderElement.setName("EDITOR_FLOW_ORDER");
                        orderElement.setElementText(orderNode.asText());
                        flowElement.addExtensionElement(orderElement);
                    }
                }
            }
        }
        if (baseElement instanceof FlowElement) {
            flowElement = (FlowElement)baseElement;
            if (flowElement instanceof SequenceFlow) {
                ExtensionElement idExtensionElement = new ExtensionElement();
                idExtensionElement.setName("EDITOR_RESOURCEID");
                idExtensionElement.setElementText(elementNode.get("resourceId").asText());
                flowElement.addExtensionElement(idExtensionElement);
            }
            if (parentElement instanceof Process) {
                ((Process)parentElement).addFlowElement(flowElement);
            } else if (parentElement instanceof SubProcess) {
                ((SubProcess)parentElement).addFlowElement(flowElement);
            } else if (parentElement instanceof Lane) {
                lane = (Lane)parentElement;
                lane.getFlowReferences().add(flowElement.getId());
                lane.getParentProcess().addFlowElement(flowElement);
            }
        } else if (baseElement instanceof Artifact) {
            Artifact artifact = (Artifact)baseElement;
            if (parentElement instanceof Process) {
                ((Process)parentElement).addArtifact(artifact);
            } else if (parentElement instanceof SubProcess) {
                ((SubProcess)parentElement).addArtifact(artifact);
            } else if (parentElement instanceof Lane) {
                lane = (Lane)parentElement;
                lane.getFlowReferences().add(artifact.getId());
                lane.getParentProcess().addArtifact(artifact);
            }
        }
    }

    protected abstract void convertElementToJson(ObjectNode var1, BaseElement var2);

    protected abstract BaseElement convertJsonToElement(JsonNode var1, JsonNode var2, Map<String, JsonNode> var3);

    protected abstract String getStencilId(BaseElement var1);

    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }

    protected void addFormProperties(List<FormProperty> formProperties, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(formProperties)) {
            return;
        }
        ObjectNode formPropertiesNode = this.objectMapper.createObjectNode();
        ArrayNode propertiesArrayNode = this.objectMapper.createArrayNode();
        for (FormProperty property : formProperties) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("id", property.getId());
            propertyItemNode.put("name", property.getName());
            propertyItemNode.put("type", property.getType());
            if (StringUtils.isNotEmpty((CharSequence)property.getExpression())) {
                propertyItemNode.put("expression", property.getExpression());
            } else {
                propertyItemNode.putNull("expression");
            }
            if (StringUtils.isNotEmpty((CharSequence)property.getVariable())) {
                propertyItemNode.put("variable", property.getVariable());
            } else {
                propertyItemNode.putNull("variable");
            }
            if (StringUtils.isNotEmpty((CharSequence)property.getDefaultExpression())) {
                propertyItemNode.put("default", property.getDefaultExpression());
            } else {
                propertyItemNode.putNull("default");
            }
            if (StringUtils.isNotEmpty((CharSequence)property.getDatePattern())) {
                propertyItemNode.put("datePattern", property.getDatePattern());
            }
            if (CollectionUtils.isNotEmpty(property.getFormValues())) {
                ArrayNode valuesNode = this.objectMapper.createArrayNode();
                for (FormValue formValue : property.getFormValues()) {
                    ObjectNode valueNode = this.objectMapper.createObjectNode();
                    valueNode.put("name", formValue.getName());
                    valueNode.put("id", formValue.getId());
                    valuesNode.add((JsonNode)valueNode);
                }
                propertyItemNode.set("enumValues", (JsonNode)valuesNode);
            }
            propertyItemNode.put("required", property.isRequired());
            propertyItemNode.put("readable", property.isReadable());
            propertyItemNode.put("writable", property.isWriteable());
            propertiesArrayNode.add((JsonNode)propertyItemNode);
        }
        formPropertiesNode.set("formProperties", (JsonNode)propertiesArrayNode);
        propertiesNode.set("formproperties", (JsonNode)formPropertiesNode);
    }

    protected void addEventOutParameters(List<ExtensionElement> eventParameterElements, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(eventParameterElements)) {
            return;
        }
        ObjectNode valueNode = this.objectMapper.createObjectNode();
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (ExtensionElement element : eventParameterElements) {
            ObjectNode itemNode = this.objectMapper.createObjectNode();
            itemNode.put("eventName", element.getAttributeValue(null, "source"));
            itemNode.put("eventType", element.getAttributeValue(null, "sourceType"));
            itemNode.put("variableName", element.getAttributeValue(null, "target"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("outParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventoutparameters", (JsonNode)valueNode);
    }

    protected void addEventOutIOParameters(List<IOParameter> eventParameters, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(eventParameters)) {
            return;
        }
        ObjectNode valueNode = this.objectMapper.createObjectNode();
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : eventParameters) {
            ObjectNode itemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                itemNode.put("eventName", parameter.getSourceExpression());
            } else {
                itemNode.put("eventName", parameter.getSource());
            }
            itemNode.put("eventType", parameter.getAttributeValue(null, "sourceType"));
            itemNode.put("variableName", parameter.getTarget());
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("outParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventoutparameters", (JsonNode)valueNode);
    }

    protected void addEventInParameters(List<ExtensionElement> eventParameterElements, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(eventParameterElements)) {
            return;
        }
        ObjectNode valueNode = this.objectMapper.createObjectNode();
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (ExtensionElement element : eventParameterElements) {
            ObjectNode itemNode = this.objectMapper.createObjectNode();
            itemNode.put("variableName", element.getAttributeValue(null, "source"));
            itemNode.put("eventName", element.getAttributeValue(null, "target"));
            itemNode.put("eventType", element.getAttributeValue(null, "targetType"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("inParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventinparameters", (JsonNode)valueNode);
    }

    protected void addEventInIOParameters(List<IOParameter> eventParameters, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(eventParameters)) {
            return;
        }
        ObjectNode valueNode = this.objectMapper.createObjectNode();
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : eventParameters) {
            ObjectNode itemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                itemNode.put("variableName", parameter.getSourceExpression());
            } else {
                itemNode.put("variableName", parameter.getSource());
            }
            itemNode.put("eventName", parameter.getTarget());
            itemNode.put("eventType", parameter.getAttributeValue(null, "targetType"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("inParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventinparameters", (JsonNode)valueNode);
    }

    protected void addEventCorrelationParameters(List<ExtensionElement> eventParameterElements, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(eventParameterElements)) {
            return;
        }
        ObjectNode valueNode = this.objectMapper.createObjectNode();
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (ExtensionElement element : eventParameterElements) {
            ObjectNode itemNode = this.objectMapper.createObjectNode();
            itemNode.put("name", element.getAttributeValue(null, "name"));
            itemNode.put("type", element.getAttributeValue(null, "nameType"));
            itemNode.put("value", element.getAttributeValue(null, "value"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("correlationParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventcorrelationparameters", (JsonNode)valueNode);
    }

    protected void addMapException(List<MapExceptionEntry> exceptions, ObjectNode propertiesNode) {
        ObjectNode exceptionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (MapExceptionEntry exception : exceptions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)exception.getClassName())) {
                propertyItemNode.put("class", exception.getClassName());
            }
            if (StringUtils.isNotEmpty((CharSequence)exception.getErrorCode())) {
                propertyItemNode.put("code", exception.getErrorCode());
            }
            propertyItemNode.put("children", Boolean.toString(exception.isAndChildren()));
            itemsNode.add((JsonNode)propertyItemNode);
        }
        exceptionsNode.set("exceptions", (JsonNode)itemsNode);
        propertiesNode.set("servicetaskexceptions", (JsonNode)exceptionsNode);
    }

    protected void addFieldExtensions(List<FieldExtension> extensions, ObjectNode propertiesNode) {
        ObjectNode fieldExtensionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FieldExtension extension : extensions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("name", extension.getFieldName());
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                propertyItemNode.put("stringValue", extension.getStringValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)extension.getExpression())) {
                propertyItemNode.put("expression", extension.getExpression());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        fieldExtensionsNode.set("fields", (JsonNode)itemsNode);
        propertiesNode.set("servicetaskfields", (JsonNode)fieldExtensionsNode);
    }

    protected void addEventProperties(Event event, ObjectNode propertiesNode) {
        List eventDefinitions = event.getEventDefinitions();
        if (eventDefinitions.size() == 1) {
            CompensateEventDefinition compensateEventDefinition;
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)errorDefinition.getErrorCode())) {
                    propertiesNode.put("errorref", errorDefinition.getErrorCode());
                }
            } else if (eventDefinition instanceof SignalEventDefinition) {
                SignalEventDefinition signalDefinition = (SignalEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)signalDefinition.getSignalRef())) {
                    propertiesNode.put("signalref", signalDefinition.getSignalRef());
                }
            } else if (eventDefinition instanceof MessageEventDefinition) {
                MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)messageDefinition.getMessageRef())) {
                    propertiesNode.put("messageref", messageDefinition.getMessageRef());
                }
            } else if (eventDefinition instanceof ConditionalEventDefinition) {
                ConditionalEventDefinition conditionalDefinition = (ConditionalEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)conditionalDefinition.getConditionExpression())) {
                    propertiesNode.put("conditionaleventcondition", conditionalDefinition.getConditionExpression());
                }
            } else if (eventDefinition instanceof TimerEventDefinition) {
                TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getCalendarName())) {
                    propertiesNode.put("calendarname", timerDefinition.getCalendarName());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDuration())) {
                    propertiesNode.put("timerdurationdefinition", timerDefinition.getTimeDuration());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeCycle())) {
                    propertiesNode.put("timercycledefinition", timerDefinition.getTimeCycle());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDate())) {
                    propertiesNode.put("timerdatedefinition", timerDefinition.getTimeDate());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getEndDate())) {
                    propertiesNode.put("timerenddatedefinition", timerDefinition.getEndDate());
                }
            } else if (eventDefinition instanceof TerminateEventDefinition) {
                TerminateEventDefinition terminateEventDefinition = (TerminateEventDefinition)eventDefinition;
                propertiesNode.put("terminateall", terminateEventDefinition.isTerminateAll());
                propertiesNode.put("terminateMultiInstance", terminateEventDefinition.isTerminateMultiInstance());
            } else if (eventDefinition instanceof CompensateEventDefinition && StringUtils.isNotEmpty((CharSequence)(compensateEventDefinition = (CompensateEventDefinition)eventDefinition).getActivityRef())) {
                propertiesNode.put("compensationactivityref", compensateEventDefinition.getActivityRef());
            }
        }
    }

    protected void convertJsonToFormProperties(JsonNode objectNode, BaseElement element) {
        JsonNode propertiesArray;
        JsonNode formPropertiesNode = this.getProperty("formproperties", objectNode);
        if (formPropertiesNode != null && (propertiesArray = (formPropertiesNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(formPropertiesNode)).get("formProperties")) != null) {
            for (JsonNode formNode : propertiesArray) {
                JsonNode enumValuesNode;
                JsonNode formIdNode = formNode.get("id");
                if (formIdNode == null || !StringUtils.isNotEmpty((CharSequence)formIdNode.asText())) continue;
                FormProperty formProperty = new FormProperty();
                formProperty.setId(formIdNode.asText());
                formProperty.setName(this.getValueAsString("name", formNode));
                formProperty.setType(this.getValueAsString("type", formNode));
                formProperty.setExpression(this.getValueAsString("expression", formNode));
                formProperty.setVariable(this.getValueAsString("variable", formNode));
                formProperty.setDefaultExpression(this.getValueAsString("default", formNode));
                if ("date".equalsIgnoreCase(formProperty.getType())) {
                    formProperty.setDatePattern(this.getValueAsString("datePattern", formNode));
                } else if ("enum".equalsIgnoreCase(formProperty.getType()) && (enumValuesNode = formNode.get("enumValues")) != null) {
                    ArrayList<FormValue> formValueList = new ArrayList<FormValue>();
                    for (JsonNode enumNode : enumValuesNode) {
                        FormValue formValue;
                        if (enumNode.get("id") != null && !enumNode.get("id").isNull() && enumNode.get("name") != null && !enumNode.get("name").isNull()) {
                            formValue = new FormValue();
                            formValue.setId(enumNode.get("id").asText());
                            formValue.setName(enumNode.get("name").asText());
                            formValueList.add(formValue);
                            continue;
                        }
                        if (enumNode.get("value") == null || enumNode.get("value").isNull()) continue;
                        formValue = new FormValue();
                        formValue.setId(enumNode.get("value").asText());
                        formValue.setName(enumNode.get("value").asText());
                        formValueList.add(formValue);
                    }
                    formProperty.setFormValues(formValueList);
                }
                formProperty.setRequired(this.getValueAsBoolean("required", formNode));
                formProperty.setReadable(this.getValueAsBoolean("readable", formNode));
                formProperty.setWriteable(this.getValueAsBoolean("writable", formNode));
                if (element instanceof StartEvent) {
                    ((StartEvent)element).getFormProperties().add(formProperty);
                    continue;
                }
                if (!(element instanceof UserTask)) continue;
                ((UserTask)element).getFormProperties().add(formProperty);
            }
        }
    }

    protected void convertJsonToTimerDefinition(JsonNode objectNode, Event event) {
        String timeDate = this.getPropertyValueAsString("timerdatedefinition", objectNode);
        String timeCycle = this.getPropertyValueAsString("timercycledefinition", objectNode);
        String timeDuration = this.getPropertyValueAsString("timerdurationdefinition", objectNode);
        String endDate = this.getPropertyValueAsString("timerenddatedefinition", objectNode);
        String calendarName = this.getPropertyValueAsString("calendarname", objectNode);
        TimerEventDefinition eventDefinition = new TimerEventDefinition();
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            eventDefinition.setCalendarName(calendarName);
        }
        if (StringUtils.isNotEmpty((CharSequence)timeDate)) {
            eventDefinition.setTimeDate(timeDate);
        } else if (StringUtils.isNotEmpty((CharSequence)timeCycle)) {
            eventDefinition.setTimeCycle(timeCycle);
        } else if (StringUtils.isNotEmpty((CharSequence)timeDuration)) {
            eventDefinition.setTimeDuration(timeDuration);
        }
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            eventDefinition.setEndDate(endDate);
        }
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToSignalDefinition(JsonNode objectNode, Event event) {
        String signalRef = this.getPropertyValueAsString("signalref", objectNode);
        SignalEventDefinition eventDefinition = new SignalEventDefinition();
        eventDefinition.setSignalRef(signalRef);
        boolean isAsync = this.getPropertyValueAsBoolean("asynchronousdefinition", objectNode);
        if (isAsync) {
            eventDefinition.setAsync(isAsync);
        }
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToCompensationDefinition(JsonNode objectNode, Event event) {
        CompensateEventDefinition eventDefinition = new CompensateEventDefinition();
        String activityRef = this.getPropertyValueAsString("compensationactivityref", objectNode);
        eventDefinition.setActivityRef(activityRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToMessageDefinition(JsonNode objectNode, Event event) {
        String messageRef = this.getPropertyValueAsString("messageref", objectNode);
        MessageEventDefinition eventDefinition = new MessageEventDefinition();
        eventDefinition.setMessageRef(messageRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToOutParameters(JsonNode objectNode, Event event) {
        JsonNode parametersNode = this.getProperty("eventoutparameters", objectNode);
        if ((parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("outParameters") != null) {
            parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("outParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("eventName") == null || parameterNode.get("eventName").isNull()) continue;
                ExtensionElement extensionElement = this.addFlowableExtensionElement("eventOutParameter", (FlowElement)event);
                String eventName = parameterNode.get("eventName").asText();
                String eventType = parameterNode.get("eventType").asText();
                String variableName = parameterNode.get("variableName").asText();
                this.addExtensionAttribute("source", eventName, extensionElement);
                this.addExtensionAttribute("sourceType", eventType, extensionElement);
                this.addExtensionAttribute("target", variableName, extensionElement);
            }
        }
    }

    protected void convertJsonToOutIOParameters(JsonNode objectNode, SendEventServiceTask task) {
        JsonNode parametersNode = this.getProperty("eventoutparameters", objectNode);
        if ((parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("outParameters") != null) {
            parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("outParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("eventName") == null || parameterNode.get("eventName").isNull()) continue;
                IOParameter parameterObject = new IOParameter();
                String eventName = parameterNode.get("eventName").asText();
                String eventType = parameterNode.get("eventType").asText();
                String variableName = parameterNode.get("variableName").asText();
                parameterObject.setSource(eventName);
                parameterObject.addAttribute(this.createExtensionAttribute("sourceType", eventType));
                if ((variableName.contains("${") || variableName.contains("#{")) && variableName.contains("}")) {
                    parameterObject.setTargetExpression(variableName);
                } else {
                    parameterObject.setTarget(variableName);
                }
                task.getEventOutParameters().add(parameterObject);
            }
        }
    }

    protected void convertJsonToInParameters(JsonNode objectNode, Event event) {
        JsonNode parametersNode = this.getProperty("eventinparameters", objectNode);
        if ((parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("inParameters") != null) {
            parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("inParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("variableName") == null || parameterNode.get("variableName").isNull()) continue;
                ExtensionElement extensionElement = this.addFlowableExtensionElement("eventInParameter", (FlowElement)event);
                String variableName = parameterNode.get("variableName").asText();
                String eventName = parameterNode.get("eventName").asText();
                String eventType = parameterNode.get("eventType").asText();
                this.addExtensionAttribute("source", variableName, extensionElement);
                this.addExtensionAttribute("target", eventName, extensionElement);
                this.addExtensionAttribute("targetType", eventType, extensionElement);
            }
        }
    }

    protected void convertJsonToInIOParameters(JsonNode objectNode, SendEventServiceTask task) {
        JsonNode parametersNode = this.getProperty("eventinparameters", objectNode);
        if ((parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("inParameters") != null) {
            parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("inParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("variableName") == null || parameterNode.get("variableName").isNull()) continue;
                IOParameter parameterObject = new IOParameter();
                String variableName = parameterNode.get("variableName").asText();
                if ((variableName.contains("${") || variableName.contains("#{")) && variableName.contains("}")) {
                    parameterObject.setSourceExpression(variableName);
                } else {
                    parameterObject.setSource(variableName);
                }
                String eventName = parameterNode.get("eventName").asText();
                String eventType = parameterNode.get("eventType").asText();
                parameterObject.setTarget(eventName);
                parameterObject.addAttribute(this.createExtensionAttribute("targetType", eventType));
                task.getEventInParameters().add(parameterObject);
            }
        }
    }

    protected void convertJsonToCorrelationParameters(JsonNode objectNode, String correlationPropertyName, FlowElement flowElement) {
        JsonNode parametersNode = this.getProperty("eventcorrelationparameters", objectNode);
        if ((parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("correlationParameters") != null) {
            parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("correlationParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("name") == null || parameterNode.get("name").isNull()) continue;
                ExtensionElement extensionElement = this.addFlowableExtensionElement(correlationPropertyName, flowElement);
                String name = parameterNode.get("name").asText();
                String type = parameterNode.get("type").asText();
                String value = parameterNode.get("value").asText();
                this.addExtensionAttribute("name", name, extensionElement);
                this.addExtensionAttribute("type", type, extensionElement);
                this.addExtensionAttribute("value", value, extensionElement);
            }
        }
    }

    protected void convertJsonToConditionalDefinition(JsonNode objectNode, Event event) {
        String condition = this.getPropertyValueAsString("conditionaleventcondition", objectNode);
        ConditionalEventDefinition eventDefinition = new ConditionalEventDefinition();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            eventDefinition.setConditionExpression(condition);
        }
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToEscalationDefinition(JsonNode objectNode, Event event) {
        String escalationRef = this.getPropertyValueAsString("escalationref", objectNode);
        EscalationEventDefinition eventDefinition = new EscalationEventDefinition();
        eventDefinition.setEscalationCode(escalationRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToErrorDefinition(JsonNode objectNode, Event event) {
        String errorRef = this.getPropertyValueAsString("errorref", objectNode);
        ErrorEventDefinition eventDefinition = new ErrorEventDefinition();
        eventDefinition.setErrorCode(errorRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    protected boolean getValueAsBoolean(String name, JsonNode objectNode) {
        boolean propertyValue = false;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asBoolean();
        }
        return propertyValue;
    }

    protected List<String> getValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode valuesNode = objectNode.get(name);
        if (valuesNode != null) {
            for (JsonNode valueNode : valuesNode) {
                if (valueNode.get("value") == null || valueNode.get("value").isNull()) continue;
                resultList.add(valueNode.get("value").asText());
            }
        }
        return resultList;
    }

    protected void addField(String name, JsonNode elementNode, ServiceTask task) {
        FieldExtension field = new FieldExtension();
        field.setFieldName(name.substring(8));
        String value = this.getPropertyValueAsString(name, elementNode);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if ((value.contains("${") || value.contains("#{")) && value.contains("}")) {
                field.setExpression(value);
            } else {
                field.setStringValue(value);
            }
            task.getFieldExtensions().add(field);
        }
    }

    protected void addField(String name, String propertyName, JsonNode elementNode, ServiceTask task) {
        this.addField(name, propertyName, null, elementNode, task);
    }

    protected void addField(String name, String propertyName, String defaultValue, JsonNode elementNode, ServiceTask task) {
        FieldExtension field = new FieldExtension();
        field.setFieldName(name);
        String value = this.getPropertyValueAsString(propertyName, elementNode);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if ((value.contains("${") || value.contains("#{")) && value.contains("}")) {
                field.setExpression(value);
            } else {
                field.setStringValue(value);
            }
            task.getFieldExtensions().add(field);
        } else if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            field.setStringValue(defaultValue);
            task.getFieldExtensions().add(field);
        }
    }

    protected String getPropertyValueAsString(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsString(name, objectNode);
    }

    protected boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode);
    }

    protected List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsList(name, objectNode);
    }

    protected JsonNode getProperty(String name, JsonNode objectNode) {
        return JsonConverterUtil.getProperty(name, objectNode);
    }

    protected String convertListToCommaSeparatedString(List<String> stringList) {
        String resultString = null;
        if (stringList != null && stringList.size() > 0) {
            StringBuilder expressionBuilder = new StringBuilder();
            for (String singleItem : stringList) {
                if (expressionBuilder.length() > 0) {
                    expressionBuilder.append(",");
                }
                expressionBuilder.append(singleItem);
            }
            resultString = expressionBuilder.toString();
        }
        return resultString;
    }

    protected ExtensionElement addFlowableExtensionElement(String name, FlowElement flowElement) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(name);
        extensionElement.setNamespace("http://flowable.org/bpmn");
        extensionElement.setNamespacePrefix("flowable");
        flowElement.addExtensionElement(extensionElement);
        return extensionElement;
    }

    protected ExtensionElement addFlowableExtensionElementWithValue(String name, String value, FlowElement flowElement) {
        ExtensionElement extensionElement = null;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            extensionElement = this.addFlowableExtensionElement(name, flowElement);
            extensionElement.setElementText(value);
        }
        return extensionElement;
    }

    public void addExtensionAttribute(String name, String value, ExtensionElement extensionElement) {
        ExtensionAttribute attribute = new ExtensionAttribute(name);
        attribute.setValue(value);
        extensionElement.addAttribute(attribute);
    }

    public ExtensionAttribute createExtensionAttribute(String name, String value) {
        ExtensionAttribute attribute = new ExtensionAttribute(name);
        attribute.setValue(value);
        return attribute;
    }
}

