/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class BoundaryEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        BoundaryEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        BoundaryEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("BoundaryTimerEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryConditionalEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryErrorEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryEscalationEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundarySignalEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryMessageEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryEventRegistryEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryCancelEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryCompensationEvent", BoundaryEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(BoundaryEvent.class, BoundaryEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        String eventType;
        BoundaryEvent boundaryEvent = (BoundaryEvent)baseElement;
        List eventDefinitions = boundaryEvent.getEventDefinitions();
        if (eventDefinitions.isEmpty() && boundaryEvent.getExtensionElements().get("eventType") != null && ((List)boundaryEvent.getExtensionElements().get("eventType")).size() > 0 && StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)((List)boundaryEvent.getExtensionElements().get("eventType")).get(0)).getElementText()))) {
            return "StartEventRegistryEvent";
        }
        if (eventDefinitions.size() != 1) {
            return "BoundaryTimerEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof ConditionalEventDefinition) {
            return "BoundaryConditionalEvent";
        }
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "BoundaryErrorEvent";
        }
        if (eventDefinition instanceof EscalationEventDefinition) {
            return "BoundaryEscalationEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "BoundarySignalEvent";
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            return "BoundaryMessageEvent";
        }
        if (eventDefinition instanceof CancelEventDefinition) {
            return "BoundaryCancelEvent";
        }
        if (eventDefinition instanceof CompensateEventDefinition) {
            return "BoundaryCompensationEvent";
        }
        return "BoundaryTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)baseElement;
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(boundaryEvent.getId());
        GraphicInfo parentGraphicInfo = this.model.getGraphicInfo(boundaryEvent.getAttachedToRef().getId());
        BigDecimal parentX = new BigDecimal(parentGraphicInfo.getX());
        BigDecimal parentY = new BigDecimal(parentGraphicInfo.getY());
        BigDecimal boundaryX = new BigDecimal(graphicInfo.getX());
        BigDecimal boundaryWidth = new BigDecimal(graphicInfo.getWidth());
        BigDecimal boundaryXMid = boundaryWidth.divide(new BigDecimal(2));
        BigDecimal boundaryY = new BigDecimal(graphicInfo.getY());
        BigDecimal boundaryHeight = new BigDecimal(graphicInfo.getHeight());
        BigDecimal boundaryYMid = boundaryHeight.divide(new BigDecimal(2));
        BigDecimal xBound = boundaryX.add(boundaryXMid).subtract(parentX).setScale(0, RoundingMode.HALF_UP);
        BigDecimal yBound = boundaryY.add(boundaryYMid).subtract(parentY).setScale(0, RoundingMode.HALF_UP);
        dockNode.put("x", xBound.intValue());
        dockNode.put("y", yBound.intValue());
        dockersArrayNode.add((JsonNode)dockNode);
        this.flowElementNode.set("dockers", (JsonNode)dockersArrayNode);
        propertiesNode.put("cancelactivity", boundaryEvent.isCancelActivity());
        this.addEventProperties((Event)boundaryEvent, propertiesNode);
        this.addEventRegistryProperties(boundaryEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        String eventKey;
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("BoundaryTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryConditionalEvent".equals(stencilId)) {
            this.convertJsonToConditionalDefinition(elementNode, (Event)boundaryEvent);
        } else if ("BoundaryErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)boundaryEvent);
        } else if ("BoundaryEscalationEvent".equals(stencilId)) {
            this.convertJsonToEscalationDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundarySignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryCancelEvent".equals(stencilId)) {
            CancelEventDefinition cancelEventDefinition = new CancelEventDefinition();
            boundaryEvent.getEventDefinitions().add(cancelEventDefinition);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryCompensationEvent".equals(stencilId)) {
            CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
            boundaryEvent.getEventDefinitions().add(compensateEventDefinition);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryEventRegistryEvent".equals(stencilId) && StringUtils.isNotEmpty((CharSequence)(eventKey = this.getPropertyValueAsString("eventkey", elementNode)))) {
            this.addFlowableExtensionElementWithValue("eventType", eventKey, (FlowElement)boundaryEvent);
            this.addFlowableExtensionElementWithValue("eventName", this.getPropertyValueAsString("eventname", elementNode), (FlowElement)boundaryEvent);
            this.convertJsonToOutParameters(elementNode, (Event)boundaryEvent);
            this.convertJsonToCorrelationParameters(elementNode, "eventCorrelationParameter", (FlowElement)boundaryEvent);
            this.addFlowableExtensionElementWithValue("channelKey", this.getPropertyValueAsString("channelkey", elementNode), (FlowElement)boundaryEvent);
            this.addFlowableExtensionElementWithValue("channelName", this.getPropertyValueAsString("channelname", elementNode), (FlowElement)boundaryEvent);
            this.addFlowableExtensionElementWithValue("channelType", this.getPropertyValueAsString("channeltype", elementNode), (FlowElement)boundaryEvent);
            this.addFlowableExtensionElementWithValue("channelDestination", this.getPropertyValueAsString("channeldestination", elementNode), (FlowElement)boundaryEvent);
            String fixedValue = this.getPropertyValueAsString("keydetectionfixedvalue", elementNode);
            String jsonField = this.getPropertyValueAsString("keydetectionjsonfield", elementNode);
            String jsonPointer = this.getPropertyValueAsString("keydetectionjsonpointer", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)fixedValue)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "fixedValue", (FlowElement)boundaryEvent);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", fixedValue, (FlowElement)boundaryEvent);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonField)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonField", (FlowElement)boundaryEvent);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonField, (FlowElement)boundaryEvent);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonPointer)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonPointer", (FlowElement)boundaryEvent);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonPointer, (FlowElement)boundaryEvent);
            }
        }
        boundaryEvent.setAttachedToRefId(this.lookForAttachedRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes")));
        return boundaryEvent;
    }

    protected String lookForAttachedRef(String boundaryEventId, JsonNode childShapesNode) {
        String attachedRefId = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !boundaryEventId.equals(resourceNode.asText())) continue;
                        attachedRefId = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (attachedRefId != null) break;
                }
                if ((attachedRefId = this.lookForAttachedRef(boundaryEventId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return attachedRefId;
    }

    protected void addEventRegistryProperties(BoundaryEvent boundaryEvent, ObjectNode propertiesNode) {
        String eventType = this.getExtensionValue("eventType", (FlowElement)boundaryEvent);
        if (StringUtils.isNotEmpty((CharSequence)eventType)) {
            this.setPropertyValue("eventkey", eventType, propertiesNode);
            this.setPropertyValue("eventname", this.getExtensionValue("eventName", (FlowElement)boundaryEvent), propertiesNode);
            this.addEventOutParameters((List)boundaryEvent.getExtensionElements().get("eventOutParameter"), propertiesNode);
            this.addEventCorrelationParameters((List)boundaryEvent.getExtensionElements().get("eventCorrelationParameter"), propertiesNode);
            this.setPropertyValue("channelkey", this.getExtensionValue("channelKey", (FlowElement)boundaryEvent), propertiesNode);
            this.setPropertyValue("channelname", this.getExtensionValue("channelName", (FlowElement)boundaryEvent), propertiesNode);
            this.setPropertyValue("channeltype", this.getExtensionValue("channelType", (FlowElement)boundaryEvent), propertiesNode);
            this.setPropertyValue("channeldestination", this.getExtensionValue("channelDestination", (FlowElement)boundaryEvent), propertiesNode);
            String keyDetectionType = this.getExtensionValue("keyDetectionType", (FlowElement)boundaryEvent);
            String keyDetectionValue = this.getExtensionValue("keyDetectionValue", (FlowElement)boundaryEvent);
            if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
                if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionfixedvalue", keyDetectionValue, propertiesNode);
                } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonfield", keyDetectionValue, propertiesNode);
                } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonpointer", keyDetectionValue, propertiesNode);
                }
            }
        }
    }

    protected String getExtensionValue(String name, FlowElement flowElement) {
        List extensionElements = (List)flowElement.getExtensionElements().get(name);
        if (extensionElements != null && extensionElements.size() > 0) {
            return ((ExtensionElement)extensionElements.get(0)).getElementText();
        }
        return null;
    }

    @Override
    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }
}

