/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.runtime.ClockReader;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.configurator.IdmEngineConfigurator;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPGroupCache;
import org.flowable.ldap.LDAPIdentityServiceImpl;
import org.flowable.ldap.LdapIdmEngineConfiguration;

public class LDAPConfigurator
extends IdmEngineConfigurator {
    protected LDAPConfiguration ldapConfiguration;

    public void beforeInit(AbstractEngineConfiguration engineConfiguration) {
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        this.idmEngineConfiguration = new LdapIdmEngineConfiguration();
        if (this.ldapConfiguration == null) {
            throw new FlowableException("ldapConfiguration is not set");
        }
        LDAPGroupCache ldapGroupCache = null;
        if (this.ldapConfiguration.getGroupCacheSize() > 0) {
            ldapGroupCache = new LDAPGroupCache(this.ldapConfiguration.getGroupCacheSize(), this.ldapConfiguration.getGroupCacheExpirationTime(), (ClockReader)engineConfiguration.getClock());
            if (this.ldapConfiguration.getGroupCacheListener() != null) {
                ldapGroupCache.setLdapCacheListener(this.ldapConfiguration.getGroupCacheListener());
            }
        }
        super.configure(engineConfiguration);
        LDAPConfigurator.getIdmEngineConfiguration(engineConfiguration).setIdmIdentityService((IdmIdentityService)new LDAPIdentityServiceImpl(this.ldapConfiguration, ldapGroupCache));
    }

    public LDAPConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    public void setLdapConfiguration(LDAPConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    protected static IdmEngineConfiguration getIdmEngineConfiguration(AbstractEngineConfiguration engineConfiguration) {
        return (IdmEngineConfiguration)engineConfiguration.getEngineConfigurations().get("cfg.idmEngine");
    }
}

