/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.scripting.ScriptBindingsFactory;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.osgi.Extender;
import org.flowable.variable.api.delegate.VariableScope;
import org.osgi.framework.InvalidSyntaxException;

public class OsgiScriptingEngines
extends ScriptingEngines {
    public OsgiScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        super(scriptBindingsFactory);
    }

    public OsgiScriptingEngines(ScriptEngineManager scriptEngineManager) {
        super(scriptEngineManager);
    }

    public Object evaluate(String script, String language, VariableScope variableScope) {
        Bindings bindings = this.createBindings(variableScope);
        return this.evaluate(script, language, bindings);
    }

    public Object evaluate(String script, String language, VariableScope variableScope, boolean storeScriptVariables) {
        return this.evaluate(script, language, this.createBindings(variableScope, storeScriptVariables));
    }

    protected Object evaluate(String script, String language, Bindings bindings) {
        ScriptEngine scriptEngine = null;
        try {
            scriptEngine = Extender.resolveScriptEngine(language);
        }
        catch (InvalidSyntaxException e) {
            throw new FlowableException("problem resolving scripting engine: " + e.getMessage(), (Throwable)e);
        }
        if (scriptEngine == null) {
            return super.evaluate(script, language, bindings);
        }
        try {
            return scriptEngine.eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new FlowableException("problem evaluating script: " + e.getMessage(), (Throwable)e);
        }
    }
}

