/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.app;

import org.flowable.app.api.AppManagementService;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.spring.AppEngineFactoryBean;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.FlowableAppProperties;
import org.flowable.spring.boot.condition.ConditionalOnAppEngine;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAppEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableAppProperties.class})
@AutoConfigureAfter(value={AppEngineAutoConfiguration.class})
public class AppEngineServicesAutoConfiguration
extends BaseEngineConfigurationWithConfigurers<SpringAppEngineConfiguration> {
    @Bean(name={"flowableAppEngine"})
    public AppEngineFactoryBean appEngine(SpringAppEngineConfiguration configuration) throws Exception {
        AppEngineFactoryBean appEngineFactoryBean = new AppEngineFactoryBean();
        appEngineFactoryBean.setAppEngineConfiguration((AppEngineConfiguration)configuration);
        this.invokeConfigurers(configuration);
        return appEngineFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public AppRepositoryService appRepositoryServiceBean(AppEngine appEngine) {
        return appEngine.getAppRepositoryService();
    }

    @Bean
    @ConditionalOnMissingBean
    public AppManagementService appManagementServiceBean(AppEngine appEngine) {
        return appEngine.getAppManagementService();
    }
}

