/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.dmn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.configurator.DmnEngineConfigurator;
import org.flowable.dmn.spring.SpringDmnEngineConfiguration;
import org.flowable.dmn.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.dmn.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.dmn.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.dmn.spring.configurator.SpringDmnEngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableAutoDeploymentProperties;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnDmnEngine;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDmnEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableAutoDeploymentProperties.class, FlowableDmnProperties.class})
@AutoConfigureAfter(value={AppEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
@AutoConfigureBefore(value={AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class DmnEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableDmnProperties dmnProperties;
    protected final FlowableAutoDeploymentProperties autoDeploymentProperties;

    public DmnEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableDmnProperties dmnProperties, FlowableAutoDeploymentProperties autoDeploymentProperties) {
        super(flowableProperties);
        this.dmnProperties = dmnProperties;
        this.autoDeploymentProperties = autoDeploymentProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringDmnEngineConfiguration dmnEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, ObjectProvider<List<AutoDeploymentStrategy<DmnEngine>>> dmnAutoDeploymentStrategies) throws IOException {
        SpringDmnEngineConfiguration configuration = new SpringDmnEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.dmnProperties.getResourceLocation(), this.dmnProperties.getResourceSuffixes(), this.dmnProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            configuration.setDeploymentResources(resources.toArray(new Resource[0]));
            configuration.setDeploymentName(this.dmnProperties.getDeploymentName());
        }
        this.configureSpringEngine((SpringEngineConfiguration)configuration, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        configuration.setHistoryEnabled(this.dmnProperties.isHistoryEnabled());
        configuration.setEnableSafeDmnXml(this.dmnProperties.isEnableSafeXml());
        configuration.setStrictMode(this.dmnProperties.isStrictMode());
        ArrayList<Object> deploymentStrategies = (ArrayList<Object>)dmnAutoDeploymentStrategies.getIfAvailable();
        if (deploymentStrategies == null) {
            deploymentStrategies = new ArrayList<Object>();
        }
        CommonAutoDeploymentProperties deploymentProperties = this.autoDeploymentProperties.deploymentPropertiesForEngine("dmn");
        deploymentStrategies.add(new DefaultAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new SingleResourceAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new ResourceParentFolderAutoDeploymentStrategy(deploymentProperties));
        configuration.setDeploymentStrategies(deploymentStrategies);
        return configuration;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class DmnEngineAppConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringDmnEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"dmnAppEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringAppEngineConfiguration> dmnAppEngineConfigurationConfigurer(DmnEngineConfigurator dmnEngineConfigurator) {
            return appEngineConfiguration -> appEngineConfiguration.addConfigurator((EngineConfigurator)dmnEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public DmnEngineConfigurator dmnEngineConfigurator(SpringDmnEngineConfiguration configuration) {
            SpringDmnEngineConfigurator dmnEngineConfigurator = new SpringDmnEngineConfigurator();
            dmnEngineConfigurator.setDmnEngineConfiguration((DmnEngineConfiguration)configuration);
            this.invokeConfigurers(configuration);
            return dmnEngineConfigurator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.spring.SpringProcessEngineConfiguration"})
    @ConditionalOnMissingBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class DmnEngineProcessConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringDmnEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"dmnProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> dmnProcessEngineConfigurationConfigurer(DmnEngineConfigurator dmnEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.addConfigurator((EngineConfigurator)dmnEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public DmnEngineConfigurator dmnEngineConfigurator(SpringDmnEngineConfiguration configuration) {
            SpringDmnEngineConfigurator dmnEngineConfigurator = new SpringDmnEngineConfigurator();
            dmnEngineConfigurator.setDmnEngineConfiguration((DmnEngineConfiguration)configuration);
            this.invokeConfigurers(configuration);
            return dmnEngineConfigurator;
        }
    }
}

