/*
 * Decompiled with CFR 0.152.
 */
package flowable;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@SpringBootApplication
public class SampleLdapApplication {
    public static void main(String[] args) {
        SpringApplication.run(SampleLdapApplication.class, (String[])args);
    }

    @Bean
    @ConditionalOnBean(value={InMemoryDirectoryServer.class})
    public CommandLineRunner initializePrivileges(IdmIdentityService idmIdentityService) {
        return args -> {
            Privilege repositoryPrivilege = idmIdentityService.createPrivilege("repository-privilege");
            Privilege managementPrivilege = idmIdentityService.createPrivilege("management-privilege");
            idmIdentityService.addGroupPrivilegeMapping(repositoryPrivilege.getId(), "user");
            idmIdentityService.addGroupPrivilegeMapping(managementPrivilege.getId(), "admin");
            idmIdentityService.addUserPrivilegeMapping(managementPrivilege.getId(), "fozzie");
        };
    }

    @Order(value=99)
    @Configuration
    class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        ApiWebSecurityConfigurationAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/process-api/**").authorizeRequests().antMatchers(new String[]{"/process-api/repository/**"})).hasAnyAuthority(new String[]{"repository-privilege"}).antMatchers(new String[]{"/process-api/management/**"})).hasAnyAuthority(new String[]{"management-privilege"}).anyRequest()).authenticated().and()).httpBasic();
        }
    }
}

