/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Token;
import org.flowable.idm.api.User;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.idm.service.PersistentTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PersistentTokenServiceImpl
implements PersistentTokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentTokenServiceImpl.class);
    private static final int DEFAULT_SERIES_LENGTH = 16;
    private static final int DEFAULT_TOKEN_LENGTH = 16;
    private SecureRandom random = new SecureRandom();
    @Autowired
    private FlowableCommonAppProperties properties;
    @Autowired
    private IdmIdentityService idmIdentityService;
    private LoadingCache<String, Token> tokenCache;

    @PostConstruct
    protected void initTokenCache() {
        FlowableCommonAppProperties.Cache cacheLoginUsers = this.properties.getCacheLoginUsers();
        long maxSize = cacheLoginUsers.getMaxSize();
        long maxAge = cacheLoginUsers.getMaxAge();
        this.tokenCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterWrite(maxAge, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, Token>(){

            public Token load(String tokenId) throws Exception {
                Token token = (Token)PersistentTokenServiceImpl.this.idmIdentityService.createTokenQuery().tokenId(tokenId).singleResult();
                if (token != null) {
                    return token;
                }
                throw new PersistentTokenNotFoundException();
            }
        });
    }

    @Override
    public Token saveAndFlush(Token token) {
        this.idmIdentityService.saveToken(token);
        return token;
    }

    @Override
    public void delete(Token token) {
        this.tokenCache.invalidate((Object)token);
        this.idmIdentityService.deleteToken(token.getId());
    }

    @Override
    public Token getPersistentToken(String tokenId) {
        return this.getPersistentToken(tokenId, false);
    }

    @Override
    public Token getPersistentToken(String tokenId, boolean invalidateCacheEntry) {
        if (invalidateCacheEntry) {
            this.tokenCache.invalidate((Object)tokenId);
        }
        try {
            return (Token)this.tokenCache.get((Object)tokenId);
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (UncheckedExecutionException e) {
            return null;
        }
    }

    private String generateSeriesData() {
        return this.generateRandomWithoutSlash(16);
    }

    private String generateTokenData() {
        return this.generateRandomWithoutSlash(16);
    }

    private String generateRandomWithoutSlash(int size) {
        String data = this.generateRandom(size);
        while (data.contains("/")) {
            data = this.generateRandom(size);
        }
        return data;
    }

    private String generateRandom(int size) {
        byte[] s = new byte[size];
        this.random.nextBytes(s);
        return new String(Base64.getEncoder().encode(s));
    }

    @Override
    public Token createToken(User user, String remoteAddress, String userAgent) {
        Token token = this.idmIdentityService.newToken(this.generateSeriesData());
        token.setTokenValue(this.generateTokenData());
        token.setTokenDate(new Date());
        token.setIpAddress(remoteAddress);
        token.setUserAgent(userAgent);
        token.setUserId(user.getId());
        try {
            this.saveAndFlush(token);
            return token;
        }
        catch (DataAccessException e) {
            LOGGER.error("Failed to save persistent token ", (Throwable)e);
            return token;
        }
    }

    private static class PersistentTokenNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private PersistentTokenNotFoundException() {
        }
    }
}

