/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.ui.idm.service.AbstractIdmService;
import org.flowable.ui.idm.service.PrivilegeService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PrivilegeServiceImpl
extends AbstractIdmService
implements PrivilegeService {
    @Override
    public Privilege findPrivilege(String id) {
        return (Privilege)this.identityService.createPrivilegeQuery().privilegeId(id).singleResult();
    }

    @Override
    public List<Privilege> findPrivileges() {
        return this.identityService.createPrivilegeQuery().list();
    }

    @Override
    public List<User> findUsersWithPrivilege(String privilegeId) {
        return this.identityService.getUsersWithPrivilege(privilegeId);
    }

    @Override
    public void addUserPrivilege(String privilegeId, String userId) {
        if (!this.isUserPrivilege(privilegeId, userId)) {
            this.identityService.addUserPrivilegeMapping(privilegeId, userId);
        }
    }

    @Override
    public void deleteUserPrivilege(String privilegeId, String userId) {
        if (this.isUserPrivilege(privilegeId, userId)) {
            this.identityService.deleteUserPrivilegeMapping(privilegeId, userId);
        }
    }

    @Override
    public List<Group> findGroupsWithPrivilege(String privilegeId) {
        return this.identityService.getGroupsWithPrivilege(privilegeId);
    }

    @Override
    public void addGroupPrivilege(String privilegeId, String groupId) {
        if (!this.isGroupPrivilege(privilegeId, groupId)) {
            this.identityService.addGroupPrivilegeMapping(privilegeId, groupId);
        }
    }

    @Override
    public void deleteGroupPrivilege(String privilegeId, String groupId) {
        if (this.isGroupPrivilege(privilegeId, groupId)) {
            this.identityService.deleteGroupPrivilegeMapping(privilegeId, groupId);
        }
    }

    protected boolean isUserPrivilege(String privilegeId, String userId) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user == null) {
            throw new IllegalArgumentException("Invalid user id");
        }
        return this.identityService.createPrivilegeQuery().privilegeId(privilegeId).userId(userId).count() > 0L;
    }

    protected boolean isGroupPrivilege(String privilegeId, String groupId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new IllegalArgumentException("Invalid group id");
        }
        return this.identityService.createPrivilegeQuery().privilegeId(privilegeId).groupId(groupId).count() > 0L;
    }
}

