/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.idm.service.AbstractIdmService;
import org.flowable.ui.idm.service.ProfileService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProfileServiceImpl
extends AbstractIdmService
implements ProfileService {
    @Override
    public User updateProfile(String firstName, String lastName, String email) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (StringUtils.isEmpty((CharSequence)email)) {
            throw new BadRequestException("Empty email is not allowed");
        }
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(currentUser.getId())).singleResult();
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        this.identityService.saveUser(user);
        return user;
    }

    @Override
    public void changePassword(String originalPassword, String newPassword) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(SecurityUtils.getCurrentUserId())).singleResult();
        if (!user.getPassword().equals(originalPassword)) {
            throw new NotFoundException();
        }
        user.setPassword(newPassword);
        this.identityService.updateUserPassword(user);
    }

    @Override
    public Pair<String, InputStream> getProfilePicture() {
        Picture picture = this.identityService.getUserPicture(SecurityUtils.getCurrentUserId());
        if (picture != null) {
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(picture.getBytes()));
            return Pair.of((Object)picture.getMimeType(), (Object)in);
        }
        return null;
    }

    @Override
    public void uploadProfilePicture(String contentType, byte[] bytes) {
        Picture picture = new Picture(bytes, contentType);
        this.identityService.setUserPicture(SecurityUtils.getCurrentUserId(), picture);
    }
}

