/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.spring.boot.ldap.FlowableLdapProperties;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.idm.cache.UserCache;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserCacheImpl
implements UserCache {
    @Autowired
    protected FlowableCommonAppProperties properties;
    protected FlowableLdapProperties ldapProperties;
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired
    protected UserService userService;
    protected LoadingCache<String, UserCache.CachedUser> userCache;

    @PostConstruct
    protected void initCache() {
        FlowableCommonAppProperties.Cache cache = this.properties.getCacheUsers();
        long userCacheMaxSize = cache.getMaxSize();
        long userCacheMaxAge = cache.getMaxAge();
        this.userCache = CacheBuilder.newBuilder().maximumSize(userCacheMaxSize).expireAfterAccess(userCacheMaxAge, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, UserCache.CachedUser>(){

            public UserCache.CachedUser load(String userId) throws Exception {
                User userFromDatabase = null;
                userFromDatabase = UserCacheImpl.this.ldapProperties == null || !UserCacheImpl.this.ldapProperties.isEnabled() ? (User)((UserQuery)UserCacheImpl.this.identityService.createUserQuery().userIdIgnoreCase(userId.toLowerCase())).singleResult() : (User)((UserQuery)UserCacheImpl.this.identityService.createUserQuery().userId(userId)).singleResult();
                if (userFromDatabase == null) {
                    throw new UsernameNotFoundException("User " + userId + " was not found in the database");
                }
                ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
                UserInformation userInformation = UserCacheImpl.this.userService.getUserInformation(userFromDatabase.getId());
                for (String privilege : userInformation.getPrivileges()) {
                    grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(privilege));
                }
                return new UserCache.CachedUser(userFromDatabase, grantedAuthorities);
            }
        });
    }

    @Override
    public void putUser(String userId, UserCache.CachedUser cachedUser) {
        this.userCache.put((Object)userId, (Object)cachedUser);
    }

    @Override
    public UserCache.CachedUser getUser(String userId) {
        return this.getUser(userId, false, false, true);
    }

    @Override
    public UserCache.CachedUser getUser(String userId, boolean throwExceptionOnNotFound, boolean throwExceptionOnInactive, boolean checkValidity) {
        try {
            UserCache.CachedUser cachedUser = (UserCache.CachedUser)this.userCache.get((Object)userId);
            return cachedUser;
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (UncheckedExecutionException uee) {
            if (uee.getCause() instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)uee.getCause();
                if (runtimeException instanceof UsernameNotFoundException) {
                    if (throwExceptionOnNotFound) {
                        throw runtimeException;
                    }
                    return null;
                }
                if (runtimeException instanceof LockedException) {
                    if (throwExceptionOnNotFound) {
                        throw runtimeException;
                    }
                    return null;
                }
            }
            throw uee;
        }
    }

    @Override
    public void invalidate(String userId) {
        this.userCache.invalidate((Object)userId);
    }

    @Autowired(required=false)
    public void setLdapProperties(FlowableLdapProperties ldapProperties) {
        this.ldapProperties = ldapProperties;
    }
}

