/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.conf;

import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.flowable.ui.modeler.properties.FlowableModelerAppProperties;
import org.flowable.ui.modeler.service.FlowableModelQueryService;
import org.flowable.ui.modeler.service.ModelImageService;
import org.flowable.ui.modeler.service.ModelServiceImpl;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.flowable.ui.modeler.servlet.ApiDispatcherServletConfiguration;
import org.flowable.ui.modeler.servlet.AppDispatcherServletConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FlowableModelerAppProperties.class})
@ComponentScan(basePackages={"org.flowable.ui.modeler.conf", "org.flowable.ui.modeler.repository", "org.flowable.ui.modeler.security", "org.flowable.ui.common.repository", "org.flowable.ui.common.tenant"})
public class ApplicationConfiguration {
    @Bean
    public ServletRegistrationBean modelerApiServlet(ApplicationContext applicationContext) {
        AnnotationConfigWebApplicationContext dispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        dispatcherServletConfiguration.setParent(applicationContext);
        dispatcherServletConfiguration.register(new Class[]{ApiDispatcherServletConfiguration.class});
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherServletConfiguration);
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{"/api/editor/*"});
        registrationBean.setName("Flowable Modeler App API Servlet");
        registrationBean.setLoadOnStartup(1);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean<DispatcherServlet> modelerAppServlet(ApplicationContext applicationContext, ObjectProvider<MultipartConfigElement> multipartConfig) {
        AnnotationConfigWebApplicationContext dispatcherServletConfiguration = new AnnotationConfigWebApplicationContext();
        dispatcherServletConfiguration.setParent(applicationContext);
        dispatcherServletConfiguration.register(new Class[]{AppDispatcherServletConfiguration.class});
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherServletConfiguration);
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, new String[]{"/modeler-app/*"});
        registrationBean.setName("Flowable Modeler App Servlet");
        registrationBean.setLoadOnStartup(1);
        registrationBean.setAsyncSupported(true);
        multipartConfig.ifAvailable(arg_0 -> ((ServletRegistrationBean)registrationBean).setMultipartConfig(arg_0));
        return registrationBean;
    }

    @Bean
    public WebMvcConfigurer modelerApplicationWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addViewControllers(@NonNull ViewControllerRegistry registry) {
                if (!ClassUtils.isPresent((String)"org.flowable.ui.task.conf.ApplicationConfiguration", (ClassLoader)this.getClass().getClassLoader())) {
                    registry.addViewController("/").setViewName("redirect:/modeler/");
                }
                registry.addViewController("/modeler").setViewName("redirect:/modeler/");
                registry.addViewController("/modeler/").setViewName("forward:/modeler/index.html");
            }
        };
    }

    @Bean
    public ModelService modelerModelService() {
        return new ModelServiceImpl();
    }

    @Bean
    public ModelImageService modelerModelImageService() {
        return new ModelImageService();
    }

    @Bean
    public FlowableModelQueryService modelerModelQueryService() {
        return new FlowableModelQueryService();
    }
}

