/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDefinitionQuery;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.idm.api.User;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskInfoQuery;
import org.flowable.task.api.TaskInfoQueryWrapper;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableTaskQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableTaskQueryService.class);
    private static final String SORT_CREATED_ASC = "created-asc";
    private static final String SORT_CREATED_DESC = "created-desc";
    private static final String SORT_DUE_ASC = "due-asc";
    private static final String SORT_DUE_DESC = "due-desc";
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected CmmnRuntimeService cmmnRuntimeService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected CmmnHistoryService cmmnHistoryService;
    @Autowired
    protected UserCache userCache;
    protected ISO8601DateFormat iso8601DateFormat = new ISO8601DateFormat();

    public ResultListDataRepresentation listTasks(ObjectNode requestNode) {
        JsonNode sortNode;
        JsonNode dueAfterNode;
        JsonNode dueBeforeNode;
        JsonNode processDefinitionNode;
        JsonNode assignmentNode;
        JsonNode textNode;
        JsonNode caseInstanceIdNode;
        JsonNode processInstanceIdNode;
        if (requestNode == null) {
            throw new BadRequestException("No request found");
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        JsonNode stateNode = requestNode.get("state");
        TaskInfoQueryWrapper taskInfoQueryWrapper = null;
        if (stateNode != null && "completed".equals(stateNode.asText())) {
            HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
            historicTaskInstanceQuery.finished();
            taskInfoQueryWrapper = new TaskInfoQueryWrapper((TaskInfoQuery)historicTaskInstanceQuery);
        } else {
            taskInfoQueryWrapper = new TaskInfoQueryWrapper((TaskInfoQuery)this.taskService.createTaskQuery());
        }
        JsonNode appDefinitionKeyNode = requestNode.get("appDefinitionKey");
        if (appDefinitionKeyNode != null && !appDefinitionKeyNode.isNull()) {
            List appDefinitions = ((AppDefinitionQuery)this.appRepositoryService.createAppDefinitionQuery().appDefinitionKey(appDefinitionKeyNode.asText())).list();
            ArrayList<String> parentDeploymentIds = new ArrayList<String>();
            for (AppDefinition appDefinition : appDefinitions) {
                parentDeploymentIds.add(appDefinition.getDeploymentId());
            }
            List deployments = this.repositoryService.createDeploymentQuery().parentDeploymentIds(parentDeploymentIds).list();
            ArrayList<String> deploymentIds = new ArrayList<String>();
            for (Deployment deployment : deployments) {
                deploymentIds.add(deployment.getId());
            }
            List cmmnDeployments = this.cmmnRepositoryService.createDeploymentQuery().parentDeploymentIds(parentDeploymentIds).list();
            ArrayList<String> cmmnDeploymentIds = new ArrayList<String>();
            for (CmmnDeployment deployment : cmmnDeployments) {
                cmmnDeploymentIds.add(deployment.getId());
            }
            taskInfoQueryWrapper.getTaskInfoQuery().or().deploymentIdIn(deploymentIds).cmmnDeploymentIdIn(cmmnDeploymentIds).taskCategory(appDefinitionKeyNode.asText()).endOr();
        }
        if ((processInstanceIdNode = requestNode.get("processInstanceId")) != null && !processInstanceIdNode.isNull()) {
            this.handleProcessInstanceFiltering(currentUser, taskInfoQueryWrapper, processInstanceIdNode);
        }
        if ((caseInstanceIdNode = requestNode.get("caseInstanceId")) != null && !caseInstanceIdNode.isNull()) {
            this.handleCaseInstanceFiltering(currentUser, taskInfoQueryWrapper, caseInstanceIdNode);
        }
        if ((textNode = requestNode.get("text")) != null && !textNode.isNull()) {
            this.handleTextFiltering(taskInfoQueryWrapper, textNode);
        }
        if ((assignmentNode = requestNode.get("assignment")) != null && !assignmentNode.isNull()) {
            this.handleAssignment(taskInfoQueryWrapper, assignmentNode, currentUser);
        }
        if ((processDefinitionNode = requestNode.get("processDefinitionId")) != null && !processDefinitionNode.isNull()) {
            this.handleProcessDefinition(taskInfoQueryWrapper, processDefinitionNode);
        }
        if ((dueBeforeNode = requestNode.get("dueBefore")) != null && !dueBeforeNode.isNull()) {
            this.handleDueBefore(taskInfoQueryWrapper, dueBeforeNode);
        }
        if ((dueAfterNode = requestNode.get("dueAfter")) != null && !dueAfterNode.isNull()) {
            this.handleDueAfter(taskInfoQueryWrapper, dueAfterNode);
        }
        if ((sortNode = requestNode.get("sort")) != null) {
            this.handleSorting(taskInfoQueryWrapper, sortNode);
        }
        int page = 0;
        JsonNode pageNode = requestNode.get("page");
        if (pageNode != null && !pageNode.isNull()) {
            page = pageNode.asInt(0);
        }
        int size = 25;
        JsonNode sizeNode = requestNode.get("size");
        if (sizeNode != null && !sizeNode.isNull()) {
            size = sizeNode.asInt(25);
        }
        List tasks = taskInfoQueryWrapper.getTaskInfoQuery().listPage(page * size, size);
        JsonNode includeProcessInstanceNode = requestNode.get("includeProcessInstance");
        HashMap<String, String> processInstancesNames = new HashMap<String, String>();
        HashMap<String, String> caseInstancesNames = new HashMap<String, String>();
        if (includeProcessInstanceNode != null) {
            this.handleIncludeProcessInstance(taskInfoQueryWrapper, includeProcessInstanceNode, tasks, processInstancesNames);
            this.handleIncludeCaseInstance(taskInfoQueryWrapper, includeProcessInstanceNode, tasks, caseInstancesNames);
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertTaskInfoList(tasks, processInstancesNames, caseInstancesNames));
        if (page != 0 || tasks.size() == size) {
            Long totalCount = taskInfoQueryWrapper.getTaskInfoQuery().count();
            result.setTotal(Long.valueOf(totalCount.intValue()));
            result.setStart(Integer.valueOf(page * size));
        }
        return result;
    }

    protected void handleProcessInstanceFiltering(User currentUser, TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode processInstanceIdNode) {
        String processInstanceId = processInstanceIdNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().processInstanceId(processInstanceId);
    }

    protected void handleCaseInstanceFiltering(User currentUser, TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode caseInstanceIdNode) {
        String caseInstanceId = caseInstanceIdNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().scopeId(caseInstanceId).scopeType("cmmn");
    }

    protected void handleTextFiltering(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode textNode) {
        String text = textNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().taskNameLikeIgnoreCase("%" + text + "%");
    }

    protected void handleAssignment(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode assignmentNode, User currentUser) {
        String assignment = assignmentNode.asText();
        if (assignment.length() > 0) {
            String currentUserId = String.valueOf(currentUser.getId());
            if ("assignee".equals(assignment)) {
                taskInfoQueryWrapper.getTaskInfoQuery().taskAssignee(currentUserId);
            } else if ("candidate".equals(assignment)) {
                RemoteUser remoteUser;
                List remoteGroups;
                taskInfoQueryWrapper.getTaskInfoQuery().taskCandidateUser(currentUserId);
                ArrayList<String> userGroupIds = new ArrayList<String>();
                if (currentUser instanceof RemoteUser && (remoteGroups = (remoteUser = (RemoteUser)currentUser).getGroups()) != null) {
                    for (RemoteGroup remoteGroup : remoteGroups) {
                        userGroupIds.add(remoteGroup.getId());
                    }
                }
                if (!userGroupIds.isEmpty()) {
                    taskInfoQueryWrapper.getTaskInfoQuery().taskCandidateGroupIn(userGroupIds);
                }
            } else if (assignment.startsWith("group_")) {
                String groupIdString = assignment.replace("group_", "");
                try {
                    Long.valueOf(groupIdString);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestException("Invalid group id");
                }
                taskInfoQueryWrapper.getTaskInfoQuery().taskCandidateGroup(groupIdString);
            } else {
                taskInfoQueryWrapper.getTaskInfoQuery().taskInvolvedUser(currentUserId);
            }
        }
    }

    protected void handleProcessDefinition(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode processDefinitionIdNode) {
        String processDefinitionId = processDefinitionIdNode.asText();
        taskInfoQueryWrapper.getTaskInfoQuery().processDefinitionId(processDefinitionId);
    }

    protected void handleDueBefore(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode dueBeforeNode) {
        String date = dueBeforeNode.asText();
        try {
            Date d = this.iso8601DateFormat.parse(date);
            taskInfoQueryWrapper.getTaskInfoQuery().taskDueBefore(d);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing due before date {}, ignoring it", (Object)date);
        }
    }

    protected void handleDueAfter(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode dueAfterNode) {
        String date = dueAfterNode.asText();
        try {
            Date d = this.iso8601DateFormat.parse(date);
            taskInfoQueryWrapper.getTaskInfoQuery().taskDueAfter(d);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing due after date {}, ignoring it", (Object)date);
        }
    }

    protected void handleSorting(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode sortNode) {
        String sort = sortNode.asText();
        if (SORT_CREATED_ASC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByTaskCreateTime().asc();
        } else if (SORT_CREATED_DESC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByTaskCreateTime().desc();
        } else if (SORT_DUE_ASC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByDueDateNullsLast().asc();
        } else if (SORT_DUE_DESC.equals(sort)) {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByDueDateNullsLast().desc();
        } else {
            taskInfoQueryWrapper.getTaskInfoQuery().orderByTaskCreateTime().desc();
        }
    }

    protected void handleIncludeProcessInstance(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode includeProcessInstanceNode, List<? extends TaskInfo> tasks, Map<String, String> processInstanceNames) {
        block6: {
            if (!includeProcessInstanceNode.asBoolean() || !CollectionUtils.isNotEmpty(tasks)) break block6;
            HashSet<String> processInstanceIds = new HashSet<String>();
            for (TaskInfo taskInfo : tasks) {
                if (taskInfo.getProcessInstanceId() == null) continue;
                processInstanceIds.add(taskInfo.getProcessInstanceId());
            }
            if (CollectionUtils.isNotEmpty(processInstanceIds)) {
                List processInstances;
                if (taskInfoQueryWrapper.getTaskInfoQuery() instanceof HistoricTaskInstanceQuery) {
                    processInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
                    for (HistoricProcessInstance processInstance : processInstances) {
                        processInstanceNames.put(processInstance.getId(), processInstance.getName());
                    }
                } else {
                    processInstances = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
                    for (ProcessInstance processInstance : processInstances) {
                        processInstanceNames.put(processInstance.getId(), processInstance.getName());
                    }
                }
            }
        }
    }

    protected void handleIncludeCaseInstance(TaskInfoQueryWrapper taskInfoQueryWrapper, JsonNode includeProcessInstanceNode, List<? extends TaskInfo> tasks, Map<String, String> caseInstanceNames) {
        block6: {
            if (!includeProcessInstanceNode.asBoolean() || !CollectionUtils.isNotEmpty(tasks)) break block6;
            HashSet<String> caseInstanceIds = new HashSet<String>();
            for (TaskInfo taskInfo : tasks) {
                if (taskInfo.getScopeId() == null) continue;
                caseInstanceIds.add(taskInfo.getScopeId());
            }
            if (CollectionUtils.isNotEmpty(caseInstanceIds)) {
                List caseInstances;
                if (taskInfoQueryWrapper.getTaskInfoQuery() instanceof HistoricTaskInstanceQuery) {
                    caseInstances = this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceIds(caseInstanceIds).list();
                    for (HistoricCaseInstance caseInstance : caseInstances) {
                        caseInstanceNames.put(caseInstance.getId(), caseInstance.getName());
                    }
                } else {
                    caseInstances = this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceIds(caseInstanceIds).list();
                    for (CaseInstance caseInstance : caseInstances) {
                        caseInstanceNames.put(caseInstance.getId(), caseInstance.getName());
                    }
                }
            }
        }
    }

    protected List<TaskRepresentation> convertTaskInfoList(List<? extends TaskInfo> tasks, Map<String, String> processInstanceNames, Map<String, String> caseInstancesNames) {
        ArrayList<TaskRepresentation> result = new ArrayList<TaskRepresentation>();
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (TaskInfo taskInfo : tasks) {
                UserCache.CachedUser cachedUser;
                TaskRepresentation taskRepresentation = null;
                if (taskInfo.getScopeDefinitionId() != null) {
                    CaseDefinition caseDefinition = this.cmmnRepositoryService.getCaseDefinition(taskInfo.getScopeDefinitionId());
                    taskRepresentation = new TaskRepresentation(taskInfo, caseDefinition, caseInstancesNames.get(taskInfo.getScopeId()));
                } else {
                    ProcessDefinitionEntity processDefinition = null;
                    if (taskInfo.getProcessDefinitionId() != null) {
                        processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(taskInfo.getProcessDefinitionId());
                    }
                    taskRepresentation = new TaskRepresentation(taskInfo, (ProcessDefinition)processDefinition, processInstanceNames.get(taskInfo.getProcessInstanceId()));
                }
                if (StringUtils.isNotEmpty((CharSequence)taskInfo.getAssignee()) && (cachedUser = this.userCache.getUser(taskInfo.getAssignee())) != null && cachedUser.getUser() != null) {
                    User assignee = cachedUser.getUser();
                    taskRepresentation.setAssignee(new UserRepresentation(assignee));
                }
                result.add(taskRepresentation);
            }
        }
        return result;
    }
}

