/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.idm.api.User;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class HistoricTaskQueryResource {
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected PermissionService permissionService;

    @PostMapping(value={"/rest/query/history/tasks"}, produces={"application/json"})
    public ResultListDataRepresentation listTasks(@RequestBody ObjectNode requestNode) {
        JsonNode finishedNode;
        if (requestNode == null) {
            throw new BadRequestException("No request found");
        }
        HistoricTaskInstanceQuery taskQuery = this.historyService.createHistoricTaskInstanceQuery();
        User currentUser = SecurityUtils.getCurrentUserObject();
        JsonNode processInstanceIdNode = requestNode.get("processInstanceId");
        if (processInstanceIdNode != null && !processInstanceIdNode.isNull()) {
            String processInstanceId = processInstanceIdNode.asText();
            if (this.permissionService.hasReadPermissionOnProcessInstance(currentUser, processInstanceId)) {
                taskQuery.processInstanceId(processInstanceId);
            } else {
                throw new NotPermittedException();
            }
        }
        if ((finishedNode = requestNode.get("finished")) != null && !finishedNode.isNull()) {
            boolean isFinished = finishedNode.asBoolean();
            if (isFinished) {
                taskQuery.finished();
            } else {
                taskQuery.unfinished();
            }
        }
        List tasks = taskQuery.list();
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertTaskInfoList(tasks));
        return result;
    }

    protected List<TaskRepresentation> convertTaskInfoList(List<HistoricTaskInstance> tasks) {
        ArrayList<TaskRepresentation> result = new ArrayList<TaskRepresentation>();
        if (CollectionUtils.isNotEmpty(tasks)) {
            TaskRepresentation representation = null;
            for (HistoricTaskInstance task : tasks) {
                representation = new TaskRepresentation(task);
                UserCache.CachedUser cachedUser = this.userCache.getUser(task.getAssignee());
                if (cachedUser != null && cachedUser.getUser() != null) {
                    representation.setAssignee(new UserRepresentation(cachedUser.getUser()));
                }
                result.add(representation);
            }
        }
        return result;
    }
}

