/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime.variable;

import java.util.List;
import org.flowable.ui.task.model.runtime.RestVariable;
import org.flowable.ui.task.rest.runtime.variable.RestVariableConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestVariableBuilder {
    public static final String BYTE_ARRAY_VARIABLE_TYPE = "binary";
    public static final String SERIALIZABLE_VARIABLE_TYPE = "serializable";
    @Autowired
    protected List<RestVariableConverter> converters;

    public RestVariable createRestVariable(String name, Object value, RestVariable.RestVariableScope scope, String id, boolean includeBinaryValue) {
        RestVariableConverter converter = null;
        RestVariable restVar = new RestVariable();
        restVar.setVariableScope(scope);
        restVar.setName(name);
        if (value != null) {
            for (RestVariableConverter c : this.converters) {
                if (!c.getVariableType().isAssignableFrom(value.getClass())) continue;
                converter = c;
                break;
            }
            if (converter != null) {
                converter.convertVariableValue(value, restVar);
                restVar.setType(converter.getRestTypeName());
            } else {
                if (value instanceof Byte[] || value instanceof byte[]) {
                    restVar.setType(BYTE_ARRAY_VARIABLE_TYPE);
                } else {
                    restVar.setType(SERIALIZABLE_VARIABLE_TYPE);
                }
                if (includeBinaryValue) {
                    restVar.setValue(value);
                }
            }
        }
        return restVar;
    }
}

