/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.persistence.entity;

import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.persistence.entity.EntityManager;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.persistence.AbstractManager;

public abstract class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public AbstractEntityManager(VariableServiceConfiguration variableServiceConfiguration) {
        super(variableServiceConfiguration);
    }

    public EntityImpl findById(String entityId) {
        return (EntityImpl)this.getDataManager().findById(entityId);
    }

    public EntityImpl create() {
        return (EntityImpl)this.getDataManager().create();
    }

    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        FlowableEventDispatcher eventDispatcher;
        this.getDataManager().insert(entity);
        if (fireCreateEvent && (eventDispatcher = this.getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, entity));
        }
    }

    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        FlowableEventDispatcher eventDispatcher;
        Entity updatedEntity = this.getDataManager().update(entity);
        if (fireUpdateEvent && (eventDispatcher = this.getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, entity));
        }
        return (EntityImpl)updatedEntity;
    }

    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        FlowableEventDispatcher eventDispatcher;
        this.getDataManager().delete(entity);
        if (fireDeleteEvent && (eventDispatcher = this.getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, entity));
        }
    }

    protected abstract DataManager<EntityImpl> getDataManager();
}

