/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class IntegerType
implements VariableType {
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return "integer";
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return new Integer(valueFields.getLongValue().intValue());
        }
        return null;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(Long.valueOf(((Integer)value).longValue()));
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Integer.class.isAssignableFrom(value.getClass()) || Integer.TYPE.isAssignableFrom(value.getClass());
    }
}

