/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.dynamic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.activiti.engine.dynamic.PropertiesParser;
import org.activiti.engine.dynamic.PropertiesParserConstants;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.engine.DynamicBpmnConstants;

public abstract class BasePropertiesParser
implements PropertiesParser,
DynamicBpmnConstants,
PropertiesParserConstants {
    @Override
    public ObjectNode parseElement(FlowElement flowElement, ObjectNode flowElementNode, ObjectMapper mapper) {
        ObjectNode resultNode = mapper.createObjectNode();
        resultNode.put("elementId", flowElement.getId());
        resultNode.put("elementType", flowElement.getClass().getSimpleName());
        if (this.supports(flowElement)) {
            resultNode.set("elementProperties", (JsonNode)this.createPropertiesNode(flowElement, flowElementNode, mapper));
        }
        return resultNode;
    }

    protected void putPropertyValue(String key, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            propertiesNode.put(key, value);
        }
    }

    protected void putPropertyValue(String key, List<String> values, ObjectNode propertiesNode) {
        if (values != null) {
            ArrayNode arrayNode = propertiesNode.putArray(key);
            for (String value : values) {
                arrayNode.add(value);
            }
        }
    }

    protected void putPropertyValue(String key, JsonNode node, ObjectNode propertiesNode) {
        if (node != null && !node.isMissingNode() && !node.isNull()) {
            propertiesNode.set(key, node);
        }
    }

    protected abstract ObjectNode createPropertiesNode(FlowElement var1, ObjectNode var2, ObjectMapper var3);

    @Override
    public abstract boolean supports(FlowElement var1);
}

