/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.rules.RulesAgendaFilter;
import org.activiti.engine.impl.rules.RulesHelper;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.BusinessRuleTaskDelegate;
import org.flowable.engine.delegate.DelegateExecution;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class BusinessRuleTaskActivityBehavior
extends TaskActivityBehavior
implements BusinessRuleTaskDelegate {
    private static final long serialVersionUID = 1L;
    protected Set<Expression> variablesInputExpressions = new HashSet<Expression>();
    protected Set<Expression> rulesExpressions = new HashSet<Expression>();
    protected boolean exclude;
    protected String resultVariable;

    @Override
    public void execute(DelegateExecution execution) {
        ActivityExecution activityExecution = (ActivityExecution)execution;
        PvmProcessDefinition processDefinition = activityExecution.getActivity().getProcessDefinition();
        String deploymentId = processDefinition.getDeploymentId();
        KieBase knowledgeBase = RulesHelper.findKnowledgeBaseByDeploymentId(deploymentId);
        KieSession ksession = knowledgeBase.newKieSession();
        if (this.variablesInputExpressions != null) {
            for (Expression variable : this.variablesInputExpressions) {
                ksession.insert(variable.getValue((VariableContainer)execution));
            }
        }
        if (!this.rulesExpressions.isEmpty()) {
            RulesAgendaFilter filter = new RulesAgendaFilter();
            for (Expression ruleName : this.rulesExpressions) {
                filter.addSuffic(ruleName.getValue((VariableContainer)execution).toString());
            }
            filter.setAccept(!this.exclude);
            ksession.fireAllRules((AgendaFilter)filter);
        } else {
            ksession.fireAllRules();
        }
        Collection ruleOutputObjects = ksession.getObjects();
        if (ruleOutputObjects != null && !ruleOutputObjects.isEmpty()) {
            ArrayList outputVariables = new ArrayList(ruleOutputObjects);
            execution.setVariable(this.resultVariable, outputVariables);
        }
        ksession.dispose();
        this.leave(activityExecution);
    }

    public void addRuleVariableInputIdExpression(Expression inputId) {
        this.variablesInputExpressions.add(inputId);
    }

    public void addRuleIdExpression(Expression inputId) {
        this.rulesExpressions.add(inputId);
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public void setResultVariable(String resultVariableName) {
        this.resultVariable = resultVariableName;
    }
}

