/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.TerminateEventDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndEventParseHandler
extends AbstractActivityBpmnParseHandler<EndEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return EndEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, EndEvent endEvent) {
        ActivityImpl endEventActivity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)endEvent, "endEvent");
        EventDefinition eventDefinition = null;
        if (!endEvent.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)endEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition instanceof ErrorEventDefinition) {
            ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
            if (bpmnParse.getBpmnModel().containsErrorRef(errorDefinition.getErrorCode())) {
                String errorCode = (String)bpmnParse.getBpmnModel().getErrors().get(errorDefinition.getErrorCode());
                if (StringUtils.isEmpty((CharSequence)errorCode)) {
                    LOGGER.warn("errorCode is required for an error event {}", (Object)endEvent.getId());
                }
                endEventActivity.setProperty("type", "errorEndEvent");
                errorDefinition.setErrorCode(errorCode);
            }
            endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createErrorEndEventActivityBehavior(endEvent, errorDefinition));
        } else if (eventDefinition instanceof CancelEventDefinition) {
            ScopeImpl scope = bpmnParse.getCurrentScope();
            if (scope.getProperty("type") == null || !scope.getProperty("type").equals("transaction")) {
                LOGGER.warn("end event with cancelEventDefinition only supported inside transaction subprocess (id={})", (Object)endEvent.getId());
            } else {
                endEventActivity.setProperty("type", "cancelEndEvent");
                endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createCancelEndEventActivityBehavior(endEvent));
            }
        } else if (eventDefinition instanceof TerminateEventDefinition) {
            endEventActivity.setAsync(endEvent.isAsynchronous());
            endEventActivity.setExclusive(!endEvent.isNotExclusive());
            endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createTerminateEndEventActivityBehavior(endEvent));
        } else if (eventDefinition == null) {
            endEventActivity.setAsync(endEvent.isAsynchronous());
            endEventActivity.setExclusive(!endEvent.isNotExclusive());
            endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
        }
    }
}

