/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import java.util.Map;
import org.activiti.engine.impl.el.ActivitiElContext;
import org.activiti.engine.impl.el.JuelExpression;
import org.activiti.engine.impl.el.ParsingElContext;
import org.activiti.engine.impl.el.ReadOnlyMapELResolver;
import org.activiti.engine.impl.el.VariableScopeElResolver;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.de.odysseus.el.ExpressionFactoryImpl;
import org.flowable.common.engine.impl.el.DynamicBeanPropertyELResolver;
import org.flowable.common.engine.impl.el.JsonNodeELResolver;
import org.flowable.common.engine.impl.javax.el.ArrayELResolver;
import org.flowable.common.engine.impl.javax.el.BeanELResolver;
import org.flowable.common.engine.impl.javax.el.CompositeELResolver;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.common.engine.impl.javax.el.ExpressionFactory;
import org.flowable.common.engine.impl.javax.el.ListELResolver;
import org.flowable.common.engine.impl.javax.el.MapELResolver;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.engine.impl.bpmn.data.ItemInstance;
import org.flowable.variable.api.delegate.VariableScope;

public class ExpressionManager {
    protected ExpressionFactory expressionFactory;
    protected ELContext parsingElContext = new ParsingElContext();
    protected Map<Object, Object> beans;

    public ExpressionManager() {
        this(null);
    }

    public ExpressionManager(boolean initFactory) {
        this(null, false);
    }

    public ExpressionManager(Map<Object, Object> beans) {
        this(beans, true);
    }

    public ExpressionManager(Map<Object, Object> beans, boolean initFactory) {
        this.expressionFactory = new ExpressionFactoryImpl();
        this.beans = beans;
    }

    public Expression createExpression(String expression) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return new JuelExpression(valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof VariableScopeImpl) {
            VariableScopeImpl variableScopeImpl = (VariableScopeImpl)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof VariableScopeImpl) {
                ((VariableScopeImpl)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    protected ActivitiElContext createElContext(VariableScope variableScope) {
        ELResolver elResolver = this.createElResolver(variableScope);
        return new ActivitiElContext(elResolver);
    }

    protected ELResolver createElResolver(VariableScope variableScope) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new JsonNodeELResolver());
        elResolver.add((ELResolver)new DynamicBeanPropertyELResolver(ItemInstance.class, "getFieldValue", "setFieldValue"));
        elResolver.add((ELResolver)new BeanELResolver());
        return elResolver;
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }
}

