/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.activiti.engine.impl.context.Context;
import org.flowable.common.engine.api.delegate.Expression;

public class TimerEventHandler {
    public static final String PROPERTYNAME_TIMER_ACTIVITY_ID = "activityId";
    public static final String PROPERTYNAME_END_DATE_EXPRESSION = "timerEndDate";
    public static final String PROPERTYNAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    public static final String PROPERTYNAME_CALENDAR_NAME_EXPRESSION = "calendarName";

    public static String createConfiguration(String id, Expression endDate, Expression calendarName) {
        ObjectNode cfgJson = TimerEventHandler.createObjectNode();
        cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, id);
        if (endDate != null) {
            cfgJson.put(PROPERTYNAME_END_DATE_EXPRESSION, endDate.getExpressionText());
        }
        if (calendarName != null) {
            cfgJson.put(PROPERTYNAME_CALENDAR_NAME_EXPRESSION, calendarName.getExpressionText());
        }
        return cfgJson.toString();
    }

    public String setActivityIdToConfiguration(String jobHandlerConfiguration, String activityId) {
        try {
            ObjectNode cfgJson = TimerEventHandler.readJsonValueAsObjectNode(jobHandlerConfiguration);
            cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, activityId);
            return cfgJson.toString();
        }
        catch (IOException ex) {
            return jobHandlerConfiguration;
        }
    }

    public static String getActivityIdFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode activityIdNode = cfgJson.get(PROPERTYNAME_TIMER_ACTIVITY_ID);
            if (activityIdNode != null) {
                return activityIdNode.asText();
            }
            return jobHandlerConfiguration;
        }
        catch (IOException ex) {
            return jobHandlerConfiguration;
        }
    }

    public static String geCalendarNameFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode calendarNameNode = cfgJson.get(PROPERTYNAME_CALENDAR_NAME_EXPRESSION);
            if (calendarNameNode != null) {
                return calendarNameNode.asText();
            }
            return "";
        }
        catch (IOException ex) {
            return "";
        }
    }

    public String setEndDateToConfiguration(String jobHandlerConfiguration, String endDate) {
        ObjectNode cfgJson = null;
        try {
            cfgJson = TimerEventHandler.readJsonValueAsObjectNode(jobHandlerConfiguration);
        }
        catch (IOException ex) {
            cfgJson = TimerEventHandler.createObjectNode();
            cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, jobHandlerConfiguration);
        }
        if (endDate != null) {
            cfgJson.put(PROPERTYNAME_END_DATE_EXPRESSION, endDate);
        }
        return cfgJson.toString();
    }

    public static String getEndDateFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode endDateNode = cfgJson.get(PROPERTYNAME_END_DATE_EXPRESSION);
            if (endDateNode != null) {
                return endDateNode.asText();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String setProcessDefinitionKeyToConfiguration(String jobHandlerConfiguration, String processDefinitionKey) {
        ObjectNode cfgJson = null;
        try {
            cfgJson = TimerEventHandler.readJsonValueAsObjectNode(jobHandlerConfiguration);
            cfgJson.put(PROPERTYNAME_PROCESS_DEFINITION_KEY, processDefinitionKey);
            return cfgJson.toString();
        }
        catch (IOException ex) {
            return jobHandlerConfiguration;
        }
    }

    public String getProcessDefinitionKeyFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode keyNode = cfgJson.get(PROPERTYNAME_PROCESS_DEFINITION_KEY);
            if (keyNode != null) {
                return keyNode.asText();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean hasRealActivityId(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode keyNode = cfgJson.get(PROPERTYNAME_PROCESS_DEFINITION_KEY);
            if (keyNode != null) {
                return keyNode.asText().length() > 0;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected static ObjectNode createObjectNode() {
        return Context.getProcessEngineConfiguration().getObjectMapper().createObjectNode();
    }

    protected static ObjectNode readJsonValueAsObjectNode(String config) throws IOException {
        return (ObjectNode)TimerEventHandler.readJsonValue(config);
    }

    protected static JsonNode readJsonValue(String config) throws IOException {
        if (Context.getCommandContext() != null) {
            return Context.getProcessEngineConfiguration().getObjectMapper().readTree(config);
        }
        return new ObjectMapper().readTree(config);
    }
}

