/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;

public class ModelEntityManager
extends AbstractManager {
    public Model createNewModel() {
        return new ModelEntity();
    }

    public void insertModel(Model model) {
        ((ModelEntity)model).setCreateTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        ((ModelEntity)model).setLastUpdateTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        this.getDbSqlSession().insert((PersistentObject)((Object)model));
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, model));
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, model));
        }
    }

    public void updateModel(ModelEntity updatedModel) {
        CommandContext commandContext = Context.getCommandContext();
        updatedModel.setLastUpdateTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update(updatedModel);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, updatedModel));
        }
    }

    public void deleteModel(String modelId) {
        ModelEntity model = this.getDbSqlSession().selectById(ModelEntity.class, modelId);
        this.getDbSqlSession().delete(model);
        this.deleteEditorSource(model);
        this.deleteEditorSourceExtra(model);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, model));
        }
    }

    public void insertEditorSourceForModel(String modelId, byte[] modelSource) {
        ModelEntity model = this.findModelById(modelId);
        if (model != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
            ref.setValue("source", modelSource);
            if (model.getEditorSourceValueId() == null) {
                model.setEditorSourceValueId(ref.getId());
                this.updateModel(model);
            }
        }
    }

    public void deleteEditorSource(ModelEntity model) {
        if (model.getEditorSourceValueId() != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
            ref.delete();
        }
    }

    public void deleteEditorSourceExtra(ModelEntity model) {
        if (model.getEditorSourceExtraValueId() != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
            ref.delete();
        }
    }

    public void insertEditorSourceExtraForModel(String modelId, byte[] modelSource) {
        ModelEntity model = this.findModelById(modelId);
        if (model != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
            ref.setValue("source-extra", modelSource);
            if (model.getEditorSourceExtraValueId() == null) {
                model.setEditorSourceExtraValueId(ref.getId());
                this.updateModel(model);
            }
        }
    }

    public ModelQuery createNewModelQuery() {
        return new ModelQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutor());
    }

    public List<Model> findModelsByQueryCriteria(ModelQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectModelsByQueryCriteria", query, page);
    }

    public long findModelCountByQueryCriteria(ModelQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectModelCountByQueryCriteria", query);
    }

    public ModelEntity findModelById(String modelId) {
        return (ModelEntity)this.getDbSqlSession().selectOne("selectModel", modelId);
    }

    public byte[] findEditorSourceByModelId(String modelId) {
        ModelEntity model = this.findModelById(modelId);
        if (model == null || model.getEditorSourceValueId() == null) {
            return null;
        }
        ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
        return ref.getBytes();
    }

    public byte[] findEditorSourceExtraByModelId(String modelId) {
        ModelEntity model = this.findModelById(modelId);
        if (model == null || model.getEditorSourceExtraValueId() == null) {
            return null;
        }
        ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
        return ref.getBytes();
    }

    public List<Model> findModelsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectModelByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findModelCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectModelCountByNativeQuery", parameterMap);
    }
}

